/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.config;

import dexlogic.parsec.config.ConfigSchema;

public class FilterSpec {
    private String style;
    private Object laneSpec;
    private Object branchSpec;
    private Class<?> dialogClass;
    ConfigSchema.FilterDriver driver;

    public FilterSpec(String string, Object object, Object object2, Class<?> clazz) {
        this.style = string;
        this.laneSpec = object;
        this.branchSpec = object2;
        this.dialogClass = clazz;
    }

    public String getStyle() {
        return this.style;
    }

    public ConfigSchema.FilterDriver getDriver() {
        return this.driver;
    }

    public String getDriverID() {
        return this.driver != null ? this.driver.getDriverID() : null;
    }

    public int getLaneCount() {
        if (this.laneSpec instanceof LaneSpec) {
            return -1;
        }
        if (this.laneSpec instanceof LaneSpec[]) {
            LaneSpec[] laneSpecArray = (LaneSpec[])this.laneSpec;
            return laneSpecArray.length;
        }
        return 0;
    }

    public int getLaneInputType(int n) {
        if (n < 0) {
            return -1;
        }
        if (this.laneSpec instanceof LaneSpec) {
            return ((LaneSpec)this.laneSpec).inputType;
        }
        if (this.laneSpec instanceof LaneSpec[]) {
            LaneSpec[] laneSpecArray = (LaneSpec[])this.laneSpec;
            return n < laneSpecArray.length ? laneSpecArray[n].inputType : -1;
        }
        return -1;
    }

    public int getLaneOutputType(int n) {
        if (n < 0) {
            return -1;
        }
        if (this.laneSpec instanceof LaneSpec) {
            return ((LaneSpec)this.laneSpec).outputType;
        }
        if (this.laneSpec instanceof LaneSpec[]) {
            LaneSpec[] laneSpecArray = (LaneSpec[])this.laneSpec;
            return n < laneSpecArray.length ? laneSpecArray[n].outputType : -1;
        }
        return -1;
    }

    public int getBranchCount() {
        if (this.branchSpec instanceof BranchSpec) {
            return -1;
        }
        if (this.branchSpec instanceof BranchSpec[]) {
            BranchSpec[] branchSpecArray = (BranchSpec[])this.branchSpec;
            return branchSpecArray.length;
        }
        return 0;
    }

    public String getBranchTitle(int n) {
        if (n < 0) {
            return null;
        }
        if (this.branchSpec instanceof BranchSpec) {
            return ((BranchSpec)this.branchSpec).title;
        }
        if (this.branchSpec instanceof BranchSpec[]) {
            BranchSpec[] branchSpecArray = (BranchSpec[])this.branchSpec;
            return n < branchSpecArray.length ? branchSpecArray[n].title : null;
        }
        return null;
    }

    public int getBranchOutputType(int n) {
        if (n < 0) {
            return -1;
        }
        if (this.branchSpec instanceof BranchSpec) {
            return ((BranchSpec)this.branchSpec).outputType;
        }
        if (this.branchSpec instanceof BranchSpec[]) {
            BranchSpec[] branchSpecArray = (BranchSpec[])this.branchSpec;
            return n < branchSpecArray.length ? branchSpecArray[n].outputType : -1;
        }
        return -1;
    }

    public Class<?> getDialogClass() {
        return this.dialogClass;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null && object instanceof FilterSpec) {
            FilterSpec filterSpec = (FilterSpec)object;
            String string = this.getDriverID();
            String string2 = filterSpec.getDriverID();
            if ((string != null && string2 != null && string.equals(string2) || string == null && string2 == null) && this.style != null && filterSpec.style != null && this.style.equals(filterSpec.style)) {
                bl = true;
            }
        }
        return bl;
    }

    public String toString() {
        return this.style;
    }

    public static class BranchSpec {
        public String title;
        public int outputType;

        public BranchSpec(String string, int n) {
            this.title = string;
            this.outputType = n;
        }
    }

    public static class LaneSpec {
        public int inputType;
        public int outputType;

        public LaneSpec(int n, int n2) {
            this.inputType = n;
            this.outputType = n2;
        }
    }
}

