/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.config;

import dexlogic.io.dln.DLNCaptureMap;
import dexlogic.parsec.ParsecException;
import dexlogic.parsec.ParsecTools;
import dexlogic.parsec.config.ConfigSchema;
import dexlogic.parsec.config.ScanPanelMerger;
import dexlogic.parsec.config.WConfigPanel;
import dexlogic.parsec.config.WJackPanel;

class DLNCaptureMerger
extends ScanPanelMerger {
    @Override
    protected void setChecked(WConfigPanel wConfigPanel, boolean bl, boolean bl2) {
        if (wConfigPanel instanceof WJackPanel) {
            ((WJackPanel)wConfigPanel).setChecked(bl, bl2);
        }
    }

    @Override
    protected boolean amendPanel(WConfigPanel wConfigPanel, Object object) throws ParsecException {
        Object object2;
        if (!(object instanceof DLNCaptureMap.CaptureEntry)) {
            return false;
        }
        DLNCaptureMap.CaptureEntry captureEntry = (DLNCaptureMap.CaptureEntry)object;
        if (captureEntry.captureID > 0 && captureEntry.captureID <= 255) {
            object2 = wConfigPanel.getSetupValue("captureID");
            Integer n = captureEntry.captureID;
            if (!((Object)n).equals(object2)) {
                wConfigPanel.putSetupValue("captureID", n);
            }
        }
        if (!ParsecTools.compareString((String)(object2 = captureEntry.captureName), (String)wConfigPanel.getSetupValue("captureName"))) {
            wConfigPanel.putSetupValue("captureName", object2);
        }
        return true;
    }

    @Override
    protected Object createPanelContext(WConfigPanel wConfigPanel) {
        PanelContext panelContext = new PanelContext();
        panelContext.captureType = ParsecTools.getServiceTypeInt(wConfigPanel.getAttrib("style"));
        if (panelContext.captureType < 0 || panelContext.captureType > 255) {
            return null;
        }
        Object object = wConfigPanel.getSetupValue("captureID");
        if (object instanceof Integer) {
            panelContext.captureID = (Integer)object;
        } else if (object == null) {
            panelContext.captureID = 0;
        } else {
            return null;
        }
        if (panelContext.captureID < 0 || panelContext.captureID > 255) {
            return null;
        }
        panelContext.captureName = (String)wConfigPanel.getSetupValue("captureName");
        return panelContext;
    }

    @Override
    protected int determinePanelMatch(Object object, Object object2) {
        if (!(object instanceof PanelContext)) {
            return 0;
        }
        PanelContext panelContext = (PanelContext)object;
        if (!(object2 instanceof DLNCaptureMap.CaptureEntry)) {
            return 0;
        }
        DLNCaptureMap.CaptureEntry captureEntry = (DLNCaptureMap.CaptureEntry)object2;
        if (captureEntry.captureType != panelContext.captureType) {
            return 0;
        }
        if (captureEntry.captureID <= 0 || captureEntry.captureID > 255) {
            return 0;
        }
        boolean bl = panelContext.captureID == captureEntry.captureID;
        boolean bl2 = panelContext.captureName != null && !panelContext.captureName.isEmpty() && panelContext.captureName.equals(captureEntry.captureName);
        int n = 0;
        if (bl2 && bl) {
            n = 3;
        } else if (bl2 && panelContext.captureID != 0) {
            n = 2;
        } else if (bl) {
            n = 1;
        }
        return n;
    }

    @Override
    protected int checkGeneric(WConfigPanel wConfigPanel) {
        int n = -1;
        Object object = wConfigPanel.getSetupValue("captureID");
        if (object instanceof Integer) {
            n = (Integer)object;
        } else if (object == null) {
            n = 0;
        } else {
            return 0;
        }
        return n == 0 ? GENTYPE_WILDCARD : 0;
    }

    @Override
    protected ConfigSchema.Element findElementSchema(WConfigPanel wConfigPanel, Object object) {
        if (object instanceof DLNCaptureMap.CaptureEntry) {
            return wConfigPanel.getElementSchema().getChildSchema("capture");
        }
        return null;
    }

    @Override
    protected WConfigPanel addConfigPanel(WConfigPanel wConfigPanel, Object object, boolean bl) throws ParsecException {
        if (!(object instanceof DLNCaptureMap.CaptureEntry)) {
            return null;
        }
        DLNCaptureMap.CaptureEntry captureEntry = (DLNCaptureMap.CaptureEntry)object;
        if (captureEntry.captureType < 0 || captureEntry.captureType > 255) {
            return null;
        }
        if (captureEntry.captureID < 0 || captureEntry.captureID > 255) {
            return null;
        }
        if (captureEntry.captureID == 0 && !bl) {
            return null;
        }
        WConfigPanel wConfigPanel2 = super.addConfigPanel(wConfigPanel, object, bl);
        if (wConfigPanel2 == null) {
            return null;
        }
        wConfigPanel2.putAttrib("style", ParsecTools.getServiceTypeText(captureEntry.captureType));
        if (captureEntry.captureID != 0) {
            wConfigPanel2.putSetupValue("captureID", captureEntry.captureID);
        }
        wConfigPanel2.putAttrib("enabled", "false");
        return wConfigPanel2;
    }

    public DLNCaptureMerger() {
        super(null);
    }

    private static class PanelContext {
        int captureType;
        int captureID;
        String captureName;

        private PanelContext() {
        }
    }
}

