/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.config;

import dexlogic.parsec.config.FilterSpec;
import dexlogic.parsec.config.SVBoolean;
import dexlogic.parsec.config.SVIDNUnitID;
import dexlogic.parsec.config.SVInteger;
import dexlogic.parsec.config.SVLSNUnitID;
import dexlogic.parsec.config.SVMeta;
import dexlogic.parsec.config.SVSockAddr;
import dexlogic.parsec.config.SVString;
import dexlogic.parsec.config.WBranchPanel;
import dexlogic.parsec.config.WCollectorPanel;
import dexlogic.parsec.config.WFeedPanel;
import dexlogic.parsec.config.WFilterDriverPanel;
import dexlogic.parsec.config.WFilterServicePanel;
import dexlogic.parsec.config.WJackPanel;
import dexlogic.parsec.config.WModulePanel;
import dexlogic.parsec.config.WSinkDSPPanel;
import dexlogic.parsec.config.WSinkDriverPanel;
import dexlogic.parsec.config.WSinkServicePanel;
import dexlogic.parsec.config.WSourceDSPPanel;
import dexlogic.parsec.config.WSourceDriverPanel;
import dexlogic.parsec.config.WSystemPanel;
import dexlogic.parsec.config.WTrunkPanel;
import dexlogic.parsec.remote.WTransformDialog;
import dexlogic.parsec.remote.WUGCDialog;
import java.util.ArrayList;

public class ConfigSchema {
    public static ArrayList<FilterSpec> filterSpecList = new ArrayList();
    public static int[] sTypeAll = new int[]{4, 5, 8, 128, 132, -1};
    public static int[] sTypeAudio = new int[]{132};
    public static Param clientGroupParam_client = new Param("clientGroup", new SVInteger(0, 0, 15), 1);
    public static Param clientGroupParam_server = new Param("clientGroup", new SVString("*"), 1);
    public static Param localAddressParam = new Param("localAddress", null, 1);
    public static Param remoteAddressParam_idn = new Param("remoteAddress", new SVSockAddr(7255), 1);
    public static Param remoteAddressParam_lsn = new Param("remoteAddress", new SVSockAddr(7272), 1);
    public static Param pushAddressParam = new Param("pushAddress", null, 1);
    public static Param pullAddressParam = new Param("pullAddress", null, 258);
    public static Param unitNameParam = new Param("unitName", null, 257);
    public static Param unitIDParam_idn = new Param("unitID", new SVIDNUnitID(), 257);
    public static Param serviceNameParam = new Param("serviceName", null, 257);
    public static Param serviceIDParam = new Param("serviceID", new SVInteger(0, 0, 255), 257);
    public static Param serviceIDParam_auto = new Param("serviceID", new SVInteger(1, 255), 257);
    public static Param serviceIDParam_reader = new Param("serviceID", new SVInteger(0, 0, 255), 0);
    public static Param msDelayParam = new Param("msDelay", new SVInteger(0), 1);
    public static Param oneWayParam = new Param("oneWay", new SVBoolean(false), 1);
    public static Param pathParam = new Param("path", null, 258);
    public static Param titleParam = new Param("title", null, 1);
    public static Param overdubParam = new Param("overdub", new SVBoolean(false), 0);
    public static Param plainStreamParam = new Param("plainStream", new SVBoolean(false), 1);
    public static Param trackNameParam = new Param("trackName", null, 257);
    public static Param anchorNumParam = new Param("anchorNum", null, 0);
    public static Param profileParam = new Param("profile", null, 0);
    public static Param mappingParam = new Param("mapping", null, 0);
    public static Param unitIDParam_lsn = new Param("unitID", new SVLSNUnitID(), 257);
    public static Param captureNameParam = new Param("captureName", null, 257);
    public static Param captureIDParam = new Param("captureID", new SVInteger(0, 0, 255), 257);
    public static Attrib refNameAttrib = new Attrib("name");
    public static Attrib styleAttrib = new Attrib("style");
    public static Attrib patchAttrib = new Attrib("patch");
    public static Attrib forkAttrib = new Attrib("fork");
    public static Attrib setupAttrib = new Attrib("setup");
    public static Attrib rpcAttrib = new Attrib("rpc");
    public static Attrib enabledAttrib = new Attrib("enabled");
    public static Attrib[] sinkServiceAttribs = new Attrib[]{refNameAttrib, styleAttrib, setupAttrib};
    public static Attrib[] moduleAttribs = new Attrib[]{refNameAttrib, styleAttrib, setupAttrib};
    public static Attrib[] filterServiceAttribs = new Attrib[]{refNameAttrib, styleAttrib, patchAttrib, setupAttrib};
    public static Attrib[] jackAttribs = new Attrib[]{enabledAttrib, refNameAttrib, styleAttrib, patchAttrib, setupAttrib};
    public static Attrib[] trunkAttribs = new Attrib[]{enabledAttrib, refNameAttrib, setupAttrib};
    public static Attrib[] feedAttribs = new Attrib[]{enabledAttrib, refNameAttrib, styleAttrib, setupAttrib};
    public static Attrib driverIDAttrib = new Attrib("driverID");
    public static Attrib[] sourceDriverAttribs = new Attrib[]{driverIDAttrib, refNameAttrib, setupAttrib};
    public static Attrib[] filterDriverAttribs = new Attrib[]{driverIDAttrib, refNameAttrib, styleAttrib, forkAttrib, setupAttrib, rpcAttrib};
    public static Attrib[] sinkDriverAttribs = new Attrib[]{driverIDAttrib, refNameAttrib, setupAttrib};
    public static Element idnClientService = new Service(sTypeAll, "Service", 0, WSinkServicePanel.class, 1, new Param[]{serviceIDParam, serviceNameParam, msDelayParam}, sinkServiceAttribs, new Element[]{ConfigSchema.buildSinkPluginElement()});
    public static Element rtClientModule = new Module("IDN-RT", "IDN-RT Client", 0, WModulePanel.class, 1, new Param[]{unitNameParam, unitIDParam_idn, remoteAddressParam_idn, oneWayParam, msDelayParam}, moduleAttribs, new Element[]{idnClientService});
    public static Driver idnClientDriver = new Driver("sinkDriver", "IDNClient", "IDN Client Driver", 0, WSinkDriverPanel.class, 1, new Param[]{clientGroupParam_client, msDelayParam}, sinkDriverAttribs, new Element[]{rtClientModule});
    public static Element idnWriterService = new Service(sTypeAll, "Track", 0, WSinkServicePanel.class, 2, new Param[]{serviceIDParam_auto, trackNameParam, msDelayParam}, sinkServiceAttribs, new Element[]{ConfigSchema.buildSinkPluginElement()});
    public static Element idnWriterModule = new Module("IDN", "IDN Writer", 0, WModulePanel.class, 2, new Param[]{pathParam, overdubParam, titleParam, plainStreamParam}, moduleAttribs, new Element[]{idnWriterService});
    public static Driver fileWriterDriver = new Driver("sinkDriver", "FileWriter", "File Writer Driver", 0, WSinkDriverPanel.class, 2, null, sinkDriverAttribs, new Element[]{idnWriterModule});
    public static Element pcmOutletService = new Service(sTypeAudio, "Service", 0, WSinkServicePanel.class, 0, new Param[]{msDelayParam}, sinkServiceAttribs, new Element[]{ConfigSchema.buildSinkPluginElement()});
    public static Element pcmOutletModule = new Module("PCM", "PCM Output", 0, WModulePanel.class, 0, new Param[0], moduleAttribs, new Element[]{pcmOutletService});
    public static Driver sysOutletDriver = new Driver("sinkDriver", "SysOutlet", "Local Output Driver", 0, WSinkDriverPanel.class, 0, null, sinkDriverAttribs, new Element[]{pcmOutletModule});
    public static Element filterBranch = new Element("branch", "Branch", 0, WBranchPanel.class, 0, null, new Attrib[]{patchAttrib}, new Element[]{ConfigSchema.buildSourcePluginElement()});
    public static Element filterService = new Service(null, "Service", 0, (Class<?>)WFilterServicePanel.class, 0, null, filterServiceAttribs, new Element[]{ConfigSchema.buildSourcePluginElement()});
    public static FilterDriver laproKitDriver = new FilterDriver("LaproKit", "Laser Projector Filter", new Element[]{filterBranch, filterService}).setFilterSpecs(new FilterSpec[]{new FilterSpec("transform", new FilterSpec.LaneSpec(128, 128), null, WTransformDialog.class), new FilterSpec("shutter", new FilterSpec.LaneSpec(128, 128), null, null), new FilterSpec("UGC", new FilterSpec.LaneSpec(128, 128), null, WUGCDialog.class)});
    public static Element idnRTJack = new Jack(sTypeAll, "Jack", 0, WJackPanel.class, 1, new Param[]{serviceIDParam_auto}, jackAttribs, new Element[]{ConfigSchema.buildSourcePluginElement()});
    public static Element idnRTTrunk = new Element("trunk", "Trunk", 0, WTrunkPanel.class, 1, new Param[]{clientGroupParam_server}, trunkAttribs, new Element[]{idnRTJack});
    public static Feed idnRTServerFeed = new Feed("IDN-RT", "IDN-RT Server", 0, WFeedPanel.class, 0, new Param[]{localAddressParam}, feedAttribs, new Element[]{idnRTTrunk});
    public static Driver idnServerDriver = new Driver("sourceDriver", "IDNServer", "IDN Server Driver", 0, WSourceDriverPanel.class, 16, null, sourceDriverAttribs, new Element[]{idnRTServerFeed});
    public static Element idnReaderJack = new Jack(null, "Jack", 16, (Class<?>)WJackPanel.class, 16, new Param[]{serviceIDParam_reader}, jackAttribs, new Element[]{ConfigSchema.buildSourcePluginElement()});
    public static Element idnReaderTrunk = new Element("trunk", "Trunk", 16, WTrunkPanel.class, 16, new Param[]{anchorNumParam}, trunkAttribs, new Element[]{idnReaderJack});
    public static Feed idnReaderFeed = new Feed("IDN", "IDN Reader", 32, WFeedPanel.class, 0, new Param[]{pathParam}, feedAttribs, new Element[]{idnReaderTrunk});
    public static Element wavReaderJack = new Jack(null, "Jack", 16, (Class<?>)WJackPanel.class, 32, new Param[]{mappingParam}, jackAttribs, new Element[]{ConfigSchema.buildSourcePluginElement()});
    public static Element wavReaderTrunk = new Element("trunk", "Trunk", 16, WTrunkPanel.class, 32, new Param[]{profileParam}, new Attrib[]{refNameAttrib, new Attrib("layout"), setupAttrib}, new Element[]{wavReaderJack});
    public static Feed wavReaderFeed = new Feed("WAV", "WAV Reader", 32, WFeedPanel.class, 0, new Param[]{pathParam}, feedAttribs, new Element[]{wavReaderTrunk});
    public static Driver fileReaderDriver = new Driver("sourceDriver", "FileReader", "File Reader Driver", 0, WSourceDriverPanel.class, 32, null, sourceDriverAttribs, new Element[]{idnReaderFeed, wavReaderFeed});
    public static Element inletJack = new Jack(sTypeAudio, "Jack", 0, WJackPanel.class, 0, null, jackAttribs, new Element[]{ConfigSchema.buildSourcePluginElement()});
    public static Element inletTrunk = new Element("trunk", "Trunk", 0, WTrunkPanel.class, 0, null, trunkAttribs, new Element[]{inletJack});
    public static Feed pcmInletFeed = new Feed("PCM", "PCM Feed", 0, WFeedPanel.class, 0, new Param[0], feedAttribs, new Element[]{inletTrunk});
    public static Driver sysInletDriver = new Driver("sourceDriver", "SysInlet", "Local Input Driver", 0, WSourceDriverPanel.class, 0, null, sourceDriverAttribs, new Element[]{pcmInletFeed});
    public static Element idnCapture = new TypedElement("capture", sTypeAll, "Capture", 0, WJackPanel.class, 4096, new Param[]{captureIDParam, captureNameParam}, jackAttribs, new Element[]{ConfigSchema.buildSourcePluginElement()});
    public static Element rtListener = new StyledElement("listener", "IDN-RT", "IDN-RT Listener", 0, WFeedPanel.class, 4096, new Param[]{unitNameParam, unitIDParam_lsn, remoteAddressParam_lsn}, new Attrib[]{enabledAttrib, refNameAttrib, styleAttrib, setupAttrib}, new Element[]{idnCapture});
    public static Element idnCollector = new Element("collector", "IDN Collector", 0, WCollectorPanel.class, 0, null, new Attrib[]{refNameAttrib}, new Element[]{rtListener});
    public static Element sourceSystemElement = new Element("sourceSystem", "Source System", 0, WSystemPanel.class, 0, null, null, new Element[]{idnServerDriver, sysInletDriver, null, idnCollector});
    public static Element renderSystemElement = new Element("renderSystem", "Render System", 0, WSystemPanel.class, 0, null, null, new Element[]{idnClientDriver, fileWriterDriver, sysOutletDriver, null, laproKitDriver, null, idnServerDriver, sysInletDriver});
    public static Element pdcxRootElement = new Element(null, null, 0, null, 0, null, null, new Element[]{sourceSystemElement, renderSystemElement});

    private static Element buildSinkPluginElement() {
        Element element = new Element("plugin", "DSP", 1, WSinkDSPPanel.class, 0, null, new Attrib[]{styleAttrib, rpcAttrib}, null);
        element.childSchemas = new Element[]{element};
        return element;
    }

    private static Element buildSourcePluginElement() {
        Element element = new Element("branch", "Branch", 0, WBranchPanel.class, 0, null, new Attrib[]{patchAttrib}, null);
        Element element2 = new Element("plugin", "DSP", 0, WSourceDSPPanel.class, 0, null, new Attrib[]{enabledAttrib, styleAttrib, patchAttrib, forkAttrib, rpcAttrib}, null);
        element2.childSchemas = new Element[]{element2, element};
        element.childSchemas = new Element[]{element2};
        return element2;
    }

    public static class FilterDriver
    extends Driver {
        private FilterSpec[] filterSpecs;

        private FilterDriver setFilterSpecs(FilterSpec[] filterSpecArray) {
            int n;
            int n2 = n = filterSpecArray == null ? 0 : filterSpecArray.length;
            for (int i = 0; i < n; ++i) {
                filterSpecArray[i].driver = this;
                filterSpecList.add(filterSpecArray[i]);
            }
            this.filterSpecs = filterSpecArray;
            return this;
        }

        private FilterDriver(String string, String string2, Element[] elementArray) {
            super("filterDriver", string, string2, 0, WFilterDriverPanel.class, 0, null, filterDriverAttribs, elementArray);
        }

        public FilterSpec[] getFilterSpecs() {
            return this.filterSpecs;
        }
    }

    public static class Driver
    extends Element {
        private String driverID;

        private Driver(String string, String string2, String string3, int n, Class<?> clazz, int n2, Param[] paramArray, Attrib[] attribArray, Element[] elementArray) {
            super(string, string3, n, clazz, n2, paramArray, attribArray, elementArray);
            this.driverID = string2;
        }

        public String getDriverID() {
            return this.driverID;
        }
    }

    public static class Feed
    extends StyledElement {
        public Feed(String string, String string2, int n, Class<?> clazz, int n2, Param[] paramArray, Attrib[] attribArray, Element[] elementArray) {
            super("feed", string, string2, n, clazz, n2, paramArray, attribArray, elementArray);
        }
    }

    public static class Module
    extends StyledElement {
        public Module(String string, String string2, int n, Class<?> clazz, int n2, Param[] paramArray, Attrib[] attribArray, Element[] elementArray) {
            super("module", string, string2, n, clazz, n2, paramArray, attribArray, elementArray);
        }
    }

    public static class StyledElement
    extends Element {
        private String style;

        public StyledElement(String string, String string2, String string3, int n, Class<?> clazz, int n2, Param[] paramArray, Attrib[] attribArray, Element[] elementArray) {
            super(string, string3, n, clazz, n2, paramArray, attribArray, elementArray);
            this.style = string2;
        }

        public String getStyle() {
            return this.style;
        }
    }

    public static class Jack
    extends TypedElement {
        public Jack(int[] nArray, String string, int n, Class<?> clazz, int n2, Param[] paramArray, Attrib[] attribArray, Element[] elementArray) {
            super("jack", nArray, string, n, clazz, n2, paramArray, attribArray, elementArray);
        }
    }

    public static class Service
    extends TypedElement {
        public Service(int[] nArray, String string, int n, Class<?> clazz, int n2, Param[] paramArray, Attrib[] attribArray, Element[] elementArray) {
            super("service", nArray, string, n, clazz, n2, paramArray, attribArray, elementArray);
        }
    }

    public static class TypedElement
    extends Element {
        private int[] types;

        public TypedElement(String string, int[] nArray, String string2, int n, Class<?> clazz, int n2, Param[] paramArray, Attrib[] attribArray, Element[] elementArray) {
            super(string, string2, n, clazz, n2, paramArray, attribArray, elementArray);
            this.types = nArray;
        }

        public int[] getTypes() {
            return this.types;
        }
    }

    public static class Element {
        private String name;
        private String title;
        private int flags;
        private Class<?> panelClass;
        private int modFlags;
        private Param[] params;
        private Attrib[] attribs;
        Element[] childSchemas;
        private static final int CONCEALED_FLAG = 32;
        private static final int DESIGNATED_FLAG = 16;
        private static final int ONLY_CHILD_FLAG = 1;

        public Element(String string, String string2, int n, Class<?> clazz, int n2, Param[] paramArray, Attrib[] attribArray, Element[] elementArray) {
            this.name = string;
            this.title = string2;
            this.flags = n;
            this.panelClass = clazz;
            this.modFlags = n2;
            this.params = paramArray;
            this.attribs = attribArray;
            this.childSchemas = elementArray;
        }

        public Element getChildSchema(String string) {
            int n;
            int n2 = n = this.childSchemas == null ? 0 : this.childSchemas.length;
            for (int i = 0; i < n; ++i) {
                Element element = this.childSchemas[i];
                if (element == null || !element.getName().equals(string)) continue;
                return element;
            }
            return null;
        }

        public String getName() {
            return this.name;
        }

        public String getTitle() {
            return this.title;
        }

        public boolean isConcealed() {
            return (this.flags & 0x20) != 0;
        }

        public boolean isDesignated() {
            return (this.flags & 0x10) != 0;
        }

        public boolean isOnlyChild() {
            return (this.flags & 1) != 0;
        }

        public Class<?> getPanelClass() {
            return this.panelClass;
        }

        public int getModFlags() {
            return this.modFlags;
        }

        public boolean hasModFlags(int n) {
            return (this.modFlags & n) == n;
        }

        public Param[] getParams() {
            return this.params;
        }

        public Attrib[] getAttribs() {
            return this.attribs;
        }

        public Element[] getChildSchemas() {
            return this.childSchemas;
        }

        public String toString() {
            return this.title;
        }
    }

    public static class Attrib {
        private String name;

        public Attrib(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class Param {
        private String name;
        private SVMeta svMeta;
        int flags;
        private static final int OUTLINE_FLAG = 256;
        private static final int CONCEALED_FLAG = 2;
        private static final int MUTABLE_FLAG = 1;

        public Param(String string, SVMeta sVMeta, int n) {
            this.name = string;
            this.svMeta = sVMeta;
            this.flags = n;
        }

        public String getName() {
            return this.name;
        }

        public SVMeta getMeta() {
            return this.svMeta;
        }

        public Object getDefaultValue() {
            return this.svMeta != null ? this.svMeta.getDefaultValue() : null;
        }

        public boolean isOutline() {
            return (this.flags & 0x100) != 0;
        }

        public boolean isConcealed() {
            return (this.flags & 2) != 0;
        }

        public boolean isMutable() {
            return (this.flags & 1) != 0;
        }
    }
}

