/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec;

import dexlogic.parsec.ParsecTools;
import dexlogic.parsec.RenderSetup;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class WSinkSetupDialog
extends JDialog {
    private RenderSetup renderSetup;
    private JTextArea textArea;

    private JComponent buildSetupUI() {
        JButton jButton = new JButton("Find Sinks");
        jButton.setEnabled(false);
        JButton jButton2 = new JButton("Load Setup...");
        jButton2.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(".");
                int n = jFileChooser.showOpenDialog(WSinkSetupDialog.this);
                if (n != 0) {
                    return;
                }
                File file = jFileChooser.getSelectedFile();
                if (file.exists()) {
                    try {
                        byte[] byArray = Files.readAllBytes(file.toPath());
                        WSinkSetupDialog.this.textArea.setText(new String(byArray, StandardCharsets.UTF_8));
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        });
        JPanel jPanel = new JPanel(new GridLayout(1, 0, 8, 0));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        return jPanel;
    }

    private JComponent buildDoneUI() {
        JButton jButton = new JButton("Apply");
        jButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    WSinkSetupDialog.this.renderSetup.setSinkSetup(WSinkSetupDialog.this.textArea.getText());
                }
                catch (Throwable throwable) {
                    Component component = (Component)actionEvent.getSource();
                    Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, component);
                    ParsecTools.showExceptionDialog(frame, "Sink Configuration Error", throwable);
                }
            }
        });
        JButton jButton2 = new JButton("Cancel");
        jButton2.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WSinkSetupDialog.this.dispose();
            }
        });
        JButton jButton3 = new JButton("OK");
        jButton3.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    WSinkSetupDialog.this.renderSetup.setSinkSetup(WSinkSetupDialog.this.textArea.getText());
                    WSinkSetupDialog.this.dispose();
                }
                catch (Throwable throwable) {
                    Component component = (Component)actionEvent.getSource();
                    Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, component);
                    ParsecTools.showExceptionDialog(frame, "Sink Configuration Error", throwable);
                }
            }
        });
        JPanel jPanel = new JPanel(new GridLayout(1, 0, 8, 0));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        return jPanel;
    }

    private JComponent buildUI() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.textArea = new JTextArea(20, 80);
        this.textArea.setText(this.renderSetup.getSinkXML());
        this.textArea.setFont(new Font("Monospaced", 0, 12));
        this.textArea.setBorder(new EmptyBorder(5, 5, 5, 5));
        JScrollPane jScrollPane = new JScrollPane(this.textArea);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(10, 0, 0, 0));
        jPanel2.add((Component)this.buildSetupUI(), "West");
        jPanel2.add((Component)this.buildDoneUI(), "East");
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    public WSinkSetupDialog(Window window, RenderSetup renderSetup) {
        super(window, "Sink Setup");
        this.renderSetup = renderSetup;
        this.setContentPane(this.buildUI());
        this.setDefaultCloseOperation(2);
    }
}

