/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec;

import dexlogic.parsec.FileSaveAction;
import dexlogic.parsec.ParsecException;
import dexlogic.parsec.ParsecTools;
import dexlogic.parsec.RefinedFileFilter;
import dexlogic.parsec.WOptionPane;
import dexlogic.parsec.config.ConfigSchema;
import dexlogic.parsec.config.FilterSpec;
import dexlogic.parsec.config.ServiceInfo;
import dexlogic.parsec.config.ServiceList;
import dexlogic.parsec.config.SetupProvider;
import dexlogic.parsec.config.SystemProxyBuilder;
import dexlogic.parsec.config.WConfigPanel;
import dexlogic.parsec.config.WSystemPanel;
import dexlogic.parsec.pdcx.PDCXReader;
import dexlogic.parsec.pdcx.PDCXWriter;
import dexlogic.parsec.routes.FlowProxyBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class WRenderSystemDialog
extends JDialog {
    private SetupProvider setupProvider;
    private File filePath;
    private boolean unsavedWorkFlag = false;
    private JScrollPane renderScrollPane;
    private WSystemPanel renderSystemPanel;
    private JButton loadButton;
    private JButton saveButton;
    private JButton saveAsButton;

    private RefinedFileFilter createFilterPDCX() {
        return new RefinedFileFilter("Parsec Driver Configuration XML", ".pdcx");
    }

    private void filenameChanged() {
        String string;
        String string2 = string = this.filePath != null ? this.filePath.getName() : null;
        if (string != null && string.toLowerCase(Locale.ENGLISH).endsWith(".pdcx")) {
            this.saveButton.setEnabled(true);
        } else {
            this.saveButton.setEnabled(false);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Render System");
        if (string != null) {
            stringBuilder.append("  -  ").append(string);
        }
        if (this.unsavedWorkFlag) {
            stringBuilder.append(" *");
        }
        this.setTitle(stringBuilder.toString());
    }

    private void save(File file) {
        File file2 = new FileSaveAction(this){

            @Override
            public void saveTo(File file) throws ParsecException {
                PDCXWriter.writeTo(file, null, WRenderSystemDialog.this.renderSystemPanel);
            }
        }.save(file, this.createFilterPDCX());
        if (file2 != null) {
            this.filePath = file2;
            this.unsavedWorkFlag = false;
            this.filenameChanged();
        }
    }

    private JComponent buildSetupUI() {
        this.loadButton = new JButton("Load...");
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(".");
                jFileChooser.setAcceptAllFileFilterUsed(false);
                jFileChooser.addChoosableFileFilter(WRenderSystemDialog.this.createFilterPDCX());
                jFileChooser.addChoosableFileFilter(new RefinedFileFilter("DexConnect Setup XML", ".xml"));
                int n = jFileChooser.showOpenDialog(WRenderSystemDialog.this);
                if (n != 0) {
                    return;
                }
                if (!WRenderSystemDialog.this.confirmDiscard()) {
                    return;
                }
                try {
                    WRenderSystemDialog.this.loadFrom(jFileChooser.getSelectedFile());
                }
                catch (Throwable throwable) {
                    WRenderSystemDialog wRenderSystemDialog = WRenderSystemDialog.this;
                    String string = "Render System File Error";
                    ParsecTools.showExceptionDialog(wRenderSystemDialog, string, throwable);
                }
            }
        });
        this.saveButton = new JButton("Save");
        this.saveButton.setEnabled(false);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WRenderSystemDialog.this.save(WRenderSystemDialog.this.filePath);
            }
        });
        this.saveAsButton = new JButton("Save As...");
        this.saveAsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WRenderSystemDialog.this.save(null);
            }
        });
        JPanel jPanel = new JPanel(new GridLayout(1, 0, 8, 0));
        jPanel.add(this.loadButton);
        jPanel.add(this.saveButton);
        jPanel.add(this.saveAsButton);
        return jPanel;
    }

    private JComponent buildUI() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.renderScrollPane = new JScrollPane();
        this.renderScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.renderScrollPane.getVerticalScrollBar().setBlockIncrement(50);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(10, 0, 0, 0));
        jPanel2.add((Component)this.buildSetupUI(), "West");
        jPanel.add((Component)this.renderScrollPane, "Center");
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    private void setUnsavedWork() {
        this.unsavedWorkFlag = true;
        this.filenameChanged();
    }

    @Override
    protected void processComponentEvent(ComponentEvent componentEvent) {
        if (componentEvent.getID() == 103) {
            this.removeNotify();
            this.setLocationByPlatform(false);
        }
        super.processComponentEvent(componentEvent);
    }

    public WRenderSystemDialog(Window window, SetupProvider setupProvider) {
        super(window);
        this.setupProvider = new SetupProvider(){
            private SetupProvider setupProvider;

            public SetupProvider init(SetupProvider setupProvider) {
                this.setupProvider = setupProvider;
                return this;
            }

            @Override
            public void appendLog(String string) {
                this.setupProvider.appendLog(string);
            }

            @Override
            public void setUnsavedWork() {
                WRenderSystemDialog.this.setUnsavedWork();
            }

            @Override
            public int requestFilterID() {
                return this.setupProvider.requestFilterID();
            }

            @Override
            public void releaseFilterID(int n) {
                this.setupProvider.releaseFilterID(n);
            }

            @Override
            public void serviceUpdate(ServiceInfo serviceInfo, ServiceInfo serviceInfo2) {
                this.setupProvider.serviceUpdate(serviceInfo, serviceInfo2);
            }

            @Override
            public ServiceList[] getServiceLists(int n) {
                return this.setupProvider.getServiceLists(n);
            }

            @Override
            public FilterSpec[] getSourcePluginOptions(int n) {
                return this.setupProvider.getSourcePluginOptions(n);
            }

            @Override
            public FilterSpec[] getSinkPluginOptions(int n) {
                return this.setupProvider.getSinkPluginOptions(n);
            }
        }.init(setupProvider);
        this.enableEvents(1L);
        this.setContentPane(this.buildUI());
        this.setDefaultCloseOperation(1);
        this.renderSystemPanel = new WSystemPanel(setupProvider, ConfigSchema.renderSystemElement);
        this.renderScrollPane.setViewportView(this.renderSystemPanel);
        this.filenameChanged();
        this.setSize(500, 400);
    }

    public boolean confirmDiscard() {
        if (this.unsavedWorkFlag) {
            this.setVisible(true);
            this.toFront();
            this.requestFocus();
            String string = "Confirmation";
            String string2 = "The render system has unsaved changes.\nDo you want to discard them?";
            return ParsecTools.showYesNoWarning(this, string, string2);
        }
        return true;
    }

    public void loadFrom(File file) throws ParsecException {
        PDCXReader pDCXReader = PDCXReader.readFrom(file, this.setupProvider);
        WSystemPanel wSystemPanel = pDCXReader.getSourceSystemPanel();
        WSystemPanel wSystemPanel2 = pDCXReader.getRenderSystemPanel();
        if (wSystemPanel2 == null) {
            wSystemPanel2 = new WSystemPanel(this.setupProvider, ConfigSchema.renderSystemElement);
        }
        if (wSystemPanel != null) {
            int n = 2;
            String string = "Load Driver Configuration";
            String string2 = "The file \"" + file.getName() + "\" contains a source system.\nDiscard source system or merge into render system?";
            Object[] objectArray = new Object[]{"Cancel", "Discard Source", "Merge"};
            WOptionPane wOptionPane = new WOptionPane(string2, n, 0);
            wOptionPane.setOptions(objectArray);
            wOptionPane.setInitialValue(objectArray[1]);
            wOptionPane.selectInitialValue();
            JDialog jDialog = wOptionPane.createDialog(this, string);
            jDialog.setVisible(true);
            jDialog.dispose();
            Object object = wOptionPane.getValue();
            if (object == null || object.equals(objectArray[0])) {
                wSystemPanel.discard();
                wSystemPanel2.discard();
                return;
            }
            if (object.equals(objectArray[2])) {
                Component[] componentArray = wSystemPanel.getStemPanels();
                int n2 = componentArray.length;
                for (int i = 0; i < n2; ++i) {
                    if (!(componentArray[i] instanceof WConfigPanel)) continue;
                    wSystemPanel2.addChildPanel((WConfigPanel)componentArray[i]);
                }
            }
            wSystemPanel.discard();
            wSystemPanel = null;
            this.filePath = null;
        } else {
            this.filePath = file;
        }
        WSystemPanel wSystemPanel3 = this.renderSystemPanel;
        this.renderSystemPanel = wSystemPanel2;
        this.renderScrollPane.setViewportView(this.renderSystemPanel);
        this.unsavedWorkFlag = false;
        this.filenameChanged();
        if (wSystemPanel3 != null) {
            wSystemPanel3.discard();
        }
    }

    public void setWorkLock(boolean bl) {
        if (this.renderSystemPanel != null) {
            this.renderSystemPanel.setWorkLock(bl);
        }
    }

    public FlowProxyBuilder getRenderProxyBuilder() {
        if (this.renderSystemPanel == null) {
            return null;
        }
        return new SystemProxyBuilder(this.renderSystemPanel);
    }
}

