/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec;

import dexlogic.parsec.GenericParsecException;
import dexlogic.parsec.InternalParsecException;
import dexlogic.parsec.ParsecTools;
import dexlogic.parsec.WEmptyRootPane;
import dexlogic.parsec.WFileChooser;
import dexlogic.parsec.WOptionPane;
import dexlogic.parsec.WParsecFrame;
import dexlogic.parsec.idn.WIDNRootPane;
import dexlogic.parsec.pdcx.WPDCXRootPane;
import dexlogic.parsec.plj.WPLJRootPane;
import dexlogic.parsec.pplx.WPPLXRootPane;
import dexlogic.parsec.xml.WXMLRootPane;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;

public class WParsecRootPane
extends JRootPane {
    private String title;

    private void fileOpenErrorMsg(Component component, String string, String string2) {
        int n = 0;
        Object[] objectArray = new Object[]{"OK"};
        WOptionPane wOptionPane = new WOptionPane(string, n, 0);
        wOptionPane.setOptions(objectArray);
        wOptionPane.setInitialValue(objectArray[0]);
        wOptionPane.selectInitialValue();
        JDialog jDialog = wOptionPane.createDialog(component, string2);
        jDialog.setVisible(true);
        jDialog.dispose();
    }

    private void openFile(String string) {
        JComponent jComponent;
        Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this);
        File file = null;
        if (string == null || string.equals("idn")) {
            jComponent = new WFileChooser(".");
            if (string != null) {
                ((JFileChooser)jComponent).setAcceptAllFileFilterUsed(false);
            }
            if (string == null || string.equals("idn")) {
                ((JFileChooser)jComponent).addChoosableFileFilter(new PFileFilter("IDN-File Format", ".idn"));
            }
            if (string == null) {
                // empty if block
            }
            int n = 0;
            n = string == null ? ((JFileChooser)jComponent).showOpenDialog(this) : ((JFileChooser)jComponent).showDialog(this, "Create");
            if (n != 0) {
                return;
            }
            file = ((JFileChooser)jComponent).getSelectedFile();
            if (string != null && file.exists()) {
                String string2 = "The file exists.\nTo open an existing file, choose from File:Open";
                this.fileOpenErrorMsg(frame, string2, "New File");
                return;
            }
        }
        if ((jComponent = WParsecRootPane.createRootPane(frame, string, file)) == null) {
            return;
        }
        if (this instanceof WEmptyRootPane) {
            WParsecFrame wParsecFrame = (WParsecFrame)this.getParent();
            wParsecFrame.setRoot((WParsecRootPane)jComponent);
            wParsecFrame.validate();
        } else {
            WParsecFrame.createFrame((WParsecRootPane)jComponent);
        }
    }

    protected JMenu buildFileMenu() {
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        return jMenu;
    }

    protected JMenuItem buildFileNewMenu() {
        JMenu jMenu = new JMenu("New");
        jMenu.setMnemonic(78);
        JMenuItem jMenuItem = jMenu.add("Playlist");
        jMenuItem.setActionCommand("pplx");
        jMenuItem.addActionListener(new FileNewAction());
        jMenuItem = jMenu.add("LaserJockey");
        jMenuItem.setActionCommand("plj");
        jMenuItem.addActionListener(new FileNewAction());
        jMenuItem = jMenu.add("Generic Streaming");
        jMenuItem.setActionCommand("pdcx");
        jMenuItem.addActionListener(new FileNewAction());
        return jMenu;
    }

    protected JMenuItem buildFileOpenItem() {
        JMenuItem jMenuItem = new JMenuItem("Open...", 79);
        jMenuItem.addActionListener(new FileOpenAction());
        return jMenuItem;
    }

    protected JMenuItem buildFileCloseItem() {
        JMenuItem jMenuItem = new JMenuItem("Close", 67);
        jMenuItem.addActionListener(new FileCloseAction());
        return jMenuItem;
    }

    protected JMenuItem buildSinkSetupItem() {
        JMenuItem jMenuItem = new JMenuItem("Sink Setup...");
        return jMenuItem;
    }

    protected JMenuItem buildServiceParamItem() {
        JMenuItem jMenuItem = new JMenuItem("Service Parameter...");
        return jMenuItem;
    }

    protected JMenuItem buildQuitItem() {
        JMenuItem jMenuItem = new JMenuItem("Quit", 81);
        jMenuItem.addActionListener(new SessionQuitAction());
        return jMenuItem;
    }

    protected JMenu buildWindowMenu() {
        JMenu jMenu = new JMenu("Window");
        jMenu.setMnemonic(87);
        jMenu.addMenuListener(new WindowMenuAdapter());
        return jMenu;
    }

    protected boolean showConfirmCloseMsg() {
        String string = "Confirmation";
        String string2 = "There is unsaved work.\nAre you sure you want to discard and quit?";
        return ParsecTools.showYesNoWarning(this, string, string2);
    }

    public boolean loadSinkSetup(File file) {
        return false;
    }

    public boolean confirmClose() {
        return true;
    }

    public void setTitle(String string) {
        this.title = string;
        JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this);
        if (jFrame != null) {
            jFrame.setTitle(string);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void dispose() {
    }

    private static WParsecRootPane createRootPane(Component component, String string, File file) {
        WParsecRootPane wParsecRootPane = null;
        try {
            Object object;
            if (file != null && file.exists()) {
                String string2;
                if (string != null) {
                    String string3 = "Root pane creation invoked with type and existing file";
                    throw new InternalParsecException(string3);
                }
                object = file.getName();
                int n = ((String)object).lastIndexOf(46);
                String string4 = string2 = n < 0 ? "" : ((String)object).substring(n);
                if (string2.equalsIgnoreCase(".pplx")) {
                    string = "pplx";
                } else if (string2.equalsIgnoreCase(".pdcx")) {
                    string = "pdcx";
                } else if (string2.equalsIgnoreCase(".idn")) {
                    string = "idn";
                } else if (string2.equalsIgnoreCase(".wav")) {
                    string = "wav";
                } else if (string2.equalsIgnoreCase(".xml")) {
                    string = "xml";
                }
                if (string == null) {
                    String string5 = "Can't handle file extension " + string2;
                    throw new GenericParsecException(string5);
                }
            } else if (string == null) {
                if (file == null) {
                    String string6 = "Root pane creation invoked without type and without file";
                    throw new InternalParsecException(string6);
                }
                String string7 = "File does not exist: " + file.getName();
                GenericParsecException genericParsecException = new GenericParsecException(string7);
                genericParsecException.setDetails("Absolute path: \n" + file.getAbsolutePath());
                throw genericParsecException;
            }
            if (string.equals("pplx")) {
                wParsecRootPane = new WPPLXRootPane(file);
            } else if (string.equals("pdcx")) {
                wParsecRootPane = new WPDCXRootPane(file);
            } else if (string.equals("idn")) {
                wParsecRootPane = new WIDNRootPane(file);
            } else if (string.equals("xml")) {
                wParsecRootPane = new WXMLRootPane(file);
            } else if (string.equals("plj")) {
                wParsecRootPane = new WPLJRootPane(file);
            }
            if (wParsecRootPane == null) {
                object = "Root pane creation invoked with invalid file type: '" + string + "'";
                throw new InternalParsecException((String)object);
            }
        }
        catch (Throwable throwable) {
            ParsecTools.showExceptionDialog(component, "File Error", throwable);
        }
        return wParsecRootPane;
    }

    public static WParsecRootPane createRootPane(String string, File file) {
        return WParsecRootPane.createRootPane(null, string, file);
    }

    private class FileCloseAction
    implements ActionListener {
        private FileCloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            WParsecFrame.closeFile((WParsecFrame)WParsecRootPane.this.getParent(), false);
        }
    }

    private class FileOpenAction
    implements ActionListener {
        private FileOpenAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            WParsecRootPane.this.openFile(null);
        }
    }

    private class FileNewAction
    implements ActionListener {
        private FileNewAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            WParsecRootPane.this.openFile(actionEvent.getActionCommand());
        }
    }

    private class WindowMenuAdapter
    implements MenuListener {
        private WindowMenuAdapter() {
        }

        @Override
        public void menuCanceled(MenuEvent menuEvent) {
        }

        @Override
        public void menuDeselected(MenuEvent menuEvent) {
        }

        @Override
        public void menuSelected(MenuEvent menuEvent) {
            WParsecFrame wParsecFrame = (WParsecFrame)WParsecRootPane.this.getParent();
            WParsecFrame.buildWindowMenu(wParsecFrame, (JMenu)menuEvent.getSource());
        }
    }

    private static class SessionQuitAction
    implements ActionListener {
        private SessionQuitAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            WParsecFrame.quitSession();
        }
    }

    private static class PFileFilter
    extends FileFilter {
        private String description;
        private String extension;

        public PFileFilter(String string, String string2) {
            this.description = string;
            this.extension = string2;
        }

        @Override
        public boolean accept(File file) {
            if (file.isHidden()) {
                return false;
            }
            if (!file.isFile()) {
                return true;
            }
            String string = file.getName();
            return string.endsWith(this.extension);
        }

        @Override
        public String getDescription() {
            return this.description + " (*" + this.extension + ")";
        }
    }
}

