/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicSliderUI;

public class SeekSliderUI
extends BasicSliderUI {
    private final RoundRectangle2D.Float trackShape = new RoundRectangle2D.Float();
    private static final int TRACK_HEIGHT = 6;
    private static final int TRACK_WIDTH = 6;
    private static final int TRACK_ARC = 4;
    private static final Dimension THUMB_SIZE = new Dimension(12, 12);

    @Override
    protected void calculateTrackRect() {
        super.calculateTrackRect();
        if (this.isHorizontal()) {
            this.trackRect.y += (this.trackRect.height - 6) / 2;
            this.trackRect.height = 6;
        } else {
            this.trackRect.x += (this.trackRect.width - 6) / 2;
            this.trackRect.width = 6;
        }
        this.trackShape.setRoundRect(this.trackRect.x, this.trackRect.y, this.trackRect.width, this.trackRect.height, 4.0f, 4.0f);
    }

    @Override
    protected void calculateThumbLocation() {
        super.calculateThumbLocation();
        if (this.isHorizontal()) {
            this.thumbRect.y = this.trackRect.y + (this.trackRect.height - this.thumbRect.height) / 2;
        } else {
            this.thumbRect.x = this.trackRect.x + (this.trackRect.width - this.thumbRect.width) / 2;
        }
    }

    @Override
    protected Dimension getThumbSize() {
        return THUMB_SIZE;
    }

    @Override
    protected FocusListener createFocusListener(JSlider jSlider) {
        return new SeekFocusListener();
    }

    @Override
    protected BasicSliderUI.TrackListener createTrackListener(JSlider jSlider) {
        return new SeekTrackListener();
    }

    public SeekSliderUI(JSlider jSlider) {
        super(jSlider);
    }

    private boolean isHorizontal() {
        return this.slider.getOrientation() == 0;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paint(graphics, jComponent);
    }

    @Override
    public void paintTrack(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Shape shape = graphics2D.getClip();
        boolean bl = this.isHorizontal();
        boolean bl2 = this.slider.getInverted();
        graphics2D.setColor(new Color(170, 170, 170));
        graphics2D.fill(this.trackShape);
        graphics2D.setColor(new Color(200, 200, 200));
        graphics2D.setClip(this.trackShape);
        this.trackShape.y += 1.0f;
        graphics2D.fill(this.trackShape);
        this.trackShape.y = this.trackRect.y;
        graphics2D.setClip(shape);
        if (bl) {
            boolean bl3 = this.slider.getComponentOrientation().isLeftToRight();
            if (bl3) {
                bl2 = !bl2;
            }
            int n = this.thumbRect.x + this.thumbRect.width / 2;
            if (bl2) {
                graphics2D.clipRect(0, 0, n, this.slider.getHeight());
            } else {
                graphics2D.clipRect(n, 0, this.slider.getWidth() - n, this.slider.getHeight());
            }
        } else {
            int n = this.thumbRect.y + this.thumbRect.height / 2;
            if (bl2) {
                graphics2D.clipRect(0, 0, this.slider.getHeight(), n);
            } else {
                graphics2D.clipRect(0, n, this.slider.getWidth(), this.slider.getHeight() - n);
            }
        }
        graphics2D.setColor(Color.ORANGE);
        graphics2D.fill(this.trackShape);
        graphics2D.setClip(shape);
    }

    @Override
    public void paintThumb(Graphics graphics) {
        graphics.setColor(new Color(246, 146, 36));
        graphics.fillOval(this.thumbRect.x, this.thumbRect.y, this.thumbRect.width, this.thumbRect.height);
    }

    @Override
    public void paintFocus(Graphics graphics) {
    }

    public class SeekTrackListener
    extends BasicSliderUI.TrackListener {
        public SeekTrackListener() {
            super(SeekSliderUI.this);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!SeekSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            SeekSliderUI.this.calculateGeometry();
            if (SeekSliderUI.this.thumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                SeekSliderUI.this.slider.setValueIsAdjusting(true);
                super.mousePressed(mouseEvent);
                return;
            }
            if (SeekSliderUI.this.slider.isRequestFocusEnabled()) {
                SeekSliderUI.this.slider.requestFocus();
            }
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            long l = mouseEvent.getWhen();
            int n = mouseEvent.getButton();
            int n2 = ((SeekSliderUI)SeekSliderUI.this).thumbRect.x + ((SeekSliderUI)SeekSliderUI.this).thumbRect.width / 2;
            int n3 = ((SeekSliderUI)SeekSliderUI.this).thumbRect.y + ((SeekSliderUI)SeekSliderUI.this).thumbRect.height / 2;
            MouseEvent mouseEvent2 = new MouseEvent(mouseEvent.getComponent(), 501, l, 0, n2, n3, mouseEvent.getClickCount(), false, n);
            super.mousePressed(mouseEvent2);
            MouseEvent mouseEvent3 = new MouseEvent(mouseEvent.getComponent(), 506, l, 0, mouseEvent.getX(), mouseEvent.getY(), 0, false, n);
            super.mouseDragged(mouseEvent3);
        }
    }

    public class SeekFocusListener
    extends BasicSliderUI.FocusHandler {
        public SeekFocusListener() {
            super(SeekSliderUI.this);
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (SeekSliderUI.this.slider.getValueIsAdjusting()) {
                MouseEvent mouseEvent = new MouseEvent(focusEvent.getComponent(), 502, 0L, 0, 0, 0, 0, false);
                SeekSliderUI.this.trackListener.mouseReleased(mouseEvent);
            }
            super.focusLost(focusEvent);
        }
    }
}

