/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec;

import dexlogic.parsec.GenericParsecException;
import dexlogic.parsec.ParsecException;
import dexlogic.parsec.WOptionPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BaseMultiResolutionImage;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.lang.reflect.Array;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class ParsecTools {
    private static final int TRACE_ELEMENT_COUNT = 5;

    public static int identityHashCode(Object object) {
        return System.identityHashCode(object);
    }

    public static String fncEntry(Object object, String string, String string2, String string3) {
        return String.format("%s(%d) %s%s%s", string, System.identityHashCode(object), string2, string3 == null ? "" : ": ", string3 == null ? "" : string3);
    }

    public static String fncEntry(Object object, String string, String string2) {
        return ParsecTools.fncEntry(object, string, string2, null);
    }

    public static String getServiceTypeText(int n) {
        if (n < 0) {
            return "";
        }
        String string = (n &= 0xFF) == 0 ? "void" : (n == 4 ? "UART" : (n == 5 ? "DMX512" : (n == 8 ? "MIDI" : (n == 128 ? "lapro" : (n == 132 ? "audio" : String.format("0x%02X", n))))));
        return string;
    }

    public static int getServiceTypeInt(String string) {
        if (string == null) {
            return -1;
        }
        if (string.equals("void")) {
            return 0;
        }
        if (string.equals("UART")) {
            return 4;
        }
        if (string.equals("DMX512")) {
            return 5;
        }
        if (string.equals("MIDI")) {
            return 8;
        }
        if (string.equals("lapro")) {
            return 128;
        }
        if (string.equals("audio")) {
            return 132;
        }
        if (string.startsWith("0x")) {
            try {
                return Integer.parseInt(string.substring(2), 16);
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public static long addDuration(long l, long l2) {
        if (l < 0L || l2 < 0L) {
            return -1L;
        }
        return l + l2;
    }

    public static String durationToString(long l) {
        if (l < 0L) {
            return "N/A";
        }
        long l2 = l / 1000L;
        long l3 = l2 / 60L;
        l2 %= 60L;
        long l4 = l3 / 60L;
        l3 %= 60L;
        if (l4 != 0L) {
            return String.format("%d:%02d:%02d", l4, l3, l2);
        }
        return String.format("%d:%02d", l3, l2);
    }

    public static boolean compareString(String string, String string2) {
        if ((string == null || string.isEmpty()) && (string2 == null || string2.isEmpty())) {
            return true;
        }
        return string != null && string2 != null && string.equals(string2);
    }

    public static String trimString(String string) {
        if (string == null) {
            return null;
        }
        return (string = string.trim()).length() == 0 ? null : string;
    }

    public static String stripString(String string) {
        if (string == null) {
            return null;
        }
        return (string = string.strip()).length() == 0 ? null : string;
    }

    public static String concatSetupParam(String string, String string2) {
        if (string != null) {
            String string3 = string = (string = string.trim()).length() == 0 ? null : string;
        }
        if (string2 != null) {
            String string4 = string2 = (string2 = string2.trim()).length() == 0 ? null : string2;
        }
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        return string + ";" + string2;
    }

    public static <T> T[] arrayNew(Class<T> clazz, int n) {
        if (n < 0) {
            return null;
        }
        Object[] objectArray = (Object[])Array.newInstance(clazz, n);
        return objectArray;
    }

    public static <T> T[] arrayAdd(Class<T> clazz, T[] TArray, T t) {
        int n = TArray == null ? 0 : TArray.length;
        Object[] objectArray = (Object[])Array.newInstance(clazz, n + 1);
        if (n > 0) {
            System.arraycopy(TArray, 0, objectArray, 0, n);
        }
        objectArray[n] = t;
        return objectArray;
    }

    public static <T> T[] arrayRemoveFirst(T[] TArray) {
        if (TArray == null) {
            return null;
        }
        int n = TArray.length - 1;
        if (n <= 0) {
            return null;
        }
        Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), n);
        System.arraycopy(TArray, 1, objectArray, 0, n);
        return objectArray;
    }

    public static <T> T[] arrayRemove(T[] TArray, T t) {
        if (TArray == null) {
            return null;
        }
        for (int i = 0; i < TArray.length; ++i) {
            if (TArray[i] != t) continue;
            int n = TArray.length - 1;
            if (n <= 0) {
                return null;
            }
            Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), n);
            System.arraycopy(TArray, 0, objectArray, 0, i);
            if (i < n) {
                System.arraycopy(TArray, i + 1, objectArray, i, n - i);
            }
            return objectArray;
        }
        return TArray;
    }

    public static Color brighter(Color color, double d) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = color.getAlpha();
        int n5 = (int)(1.0 / (1.0 - d));
        if (n == 0 && n2 == 0 && n3 == 0) {
            return new Color(n5, n5, n5, n4);
        }
        if (n > 0 && n < n5) {
            n = n5;
        }
        if (n2 > 0 && n2 < n5) {
            n2 = n5;
        }
        if (n3 > 0 && n3 < n5) {
            n3 = n5;
        }
        return new Color(Math.min((int)((double)n / d), 255), Math.min((int)((double)n2 / d), 255), Math.min((int)((double)n3 / d), 255), n4);
    }

    public static Color darker(Color color, double d) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = color.getAlpha();
        return new Color(Math.max((int)((double)n * d), 0), Math.max((int)((double)n2 * d), 0), Math.max((int)((double)n3 * d), 0), n4);
    }

    public static ImageIcon getImageIcon(String string) {
        try {
            InputStream inputStream = ParsecTools.class.getResourceAsStream(string);
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            int n = bufferedImage.getWidth();
            int n2 = bufferedImage.getHeight();
            int n3 = (int)((double)n * 1.25);
            int n4 = (int)((double)n2 * 1.25);
            BufferedImage bufferedImage2 = new BufferedImage(n3, n4, 2);
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.drawImage((Image)bufferedImage, (n3 - n) / 2, (n4 - n2) / 2, null);
            graphics2D.dispose();
            return new ImageIcon(new BaseMultiResolutionImage(bufferedImage, bufferedImage2));
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static boolean showYesNoWarning(Component component, String string, String string2) {
        int n = 2;
        Object[] objectArray = new Object[]{"Yes", "No"};
        WOptionPane wOptionPane = new WOptionPane(string2, n, 0);
        wOptionPane.setOptions(objectArray);
        wOptionPane.setInitialValue(objectArray[1]);
        wOptionPane.selectInitialValue();
        Window window = component instanceof Window ? (Window)component : (Window)SwingUtilities.getAncestorOfClass(Window.class, component);
        JDialog jDialog = wOptionPane.createDialog(window, string);
        jDialog.setVisible(true);
        jDialog.dispose();
        Object object = wOptionPane.getValue();
        if (object == null) {
            return false;
        }
        return object.equals(objectArray[0]);
    }

    public static String getTraceDetails(Throwable throwable) {
        String string;
        Object object = throwable.getClass().getName();
        String string2 = throwable.getMessage();
        if (string2 != null) {
            object = (String)object + ":\n" + string2;
        }
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        for (int i = 0; i < 5 && i < stackTraceElementArray.length; ++i) {
            object = (String)object + "\n    at " + stackTraceElementArray[i].toString();
        }
        if (throwable instanceof ParsecException && (string = ((ParsecException)throwable).getDetails()) != null) {
            object = (String)object + "\n\n" + string;
        }
        return object;
    }

    public static void showExceptionDialog(Component component, String string, Throwable throwable) {
        Object object;
        Throwable throwable2;
        String string2;
        Object object2;
        Object object3 = throwable.getClass().getName();
        String string3 = throwable.getMessage();
        if (string3 != null) {
            object3 = (String)object3 + ":\n" + string3;
        }
        Object object4 = object3;
        if (throwable instanceof GenericParsecException) {
            if (string3 != null) {
                object4 = string3;
            }
            if ((object2 = ((GenericParsecException)throwable).getHints()) != null) {
                object4 = (String)object4 + "\n\n" + (String)object2;
                object3 = (String)object3 + "\n" + (String)object2;
            }
        }
        object2 = throwable.getStackTrace();
        for (int i = 0; i < 5 && i < ((StackTraceElement[])object2).length; ++i) {
            object3 = (String)object3 + "\n    at " + object2[i].toString();
        }
        if (throwable instanceof ParsecException && (string2 = ((ParsecException)throwable).getDetails()) != null) {
            object3 = (String)object3 + "\n\n" + string2;
        }
        if ((throwable2 = throwable.getCause()) != null) {
            object3 = (String)object3 + "\n\ncause: " + throwable2.getClass().getName();
            object = throwable2.getMessage();
            if (object != null) {
                object3 = (String)object3 + ":\n" + (String)object;
            }
            object2 = throwable2.getStackTrace();
            for (int i = 0; i < 5 && i < ((StackTraceElement[])object2).length; ++i) {
                object3 = (String)object3 + "\n    at " + object2[i].toString();
            }
        }
        object = new JPanel();
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(1, 5));
        JTextArea jTextArea = new JTextArea((String)object3);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jTextArea.setEditable(false);
        jTextArea.setFont(new Font("Monospaced", 0, jTextArea.getFont().getSize()));
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setHorizontalScrollBarPolicy(32);
        JButton jButton = new JButton("Show Details");
        jButton.addActionListener(new ActionListener(){
            JScrollPane scrollPane;

            public ActionListener init(JScrollPane jScrollPane) {
                this.scrollPane = jScrollPane;
                return this;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JButton jButton = (JButton)actionEvent.getSource();
                JDialog jDialog = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, jButton);
                boolean bl = !this.scrollPane.isVisible();
                this.scrollPane.setVisible(bl);
                jButton.setText(bl ? "Hide Details" : "Show Details");
                jDialog.pack();
            }
        }.init(jScrollPane));
        int n = 0;
        Object[] objectArray = new Object[]{object4, object, jScrollPane, jPanel};
        JOptionPane jOptionPane = new JOptionPane(objectArray, n, 0){

            @Override
            public int getMaxCharactersPerLineCount() {
                return 80;
            }
        };
        String string4 = "OK";
        Object[] objectArray2 = new Object[]{jButton, string4};
        jOptionPane.setOptions(objectArray2);
        jOptionPane.setInitialValue(string4);
        jOptionPane.selectInitialValue();
        Window window = component instanceof Window ? (Window)component : (Window)SwingUtilities.getAncestorOfClass(Window.class, component);
        JDialog jDialog = jOptionPane.createDialog(window, string);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = jScrollPane.getPreferredSize();
        int n2 = dimension2.width;
        if (n2 > dimension.width / 3) {
            n2 = dimension.width / 3;
        }
        ((JComponent)object).setPreferredSize(new Dimension(n2, 5));
        int n3 = dimension2.height;
        if (n3 > dimension.height / 5) {
            n3 = dimension.height / 5;
        }
        jScrollPane.setPreferredSize(new Dimension(n2, n3));
        jScrollPane.setVisible(false);
        jDialog.pack();
        jDialog.setLocationRelativeTo(window);
        jDialog.setLocationByPlatform(true);
        jDialog.setVisible(true);
        jDialog.dispose();
    }
}

