/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec;

import dexlogic.parsec.GenericParsecException;
import dexlogic.parsec.ParsecException;
import dexlogic.parsec.ParsecTools;
import dexlogic.parsec.RefinedFileFilter;
import dexlogic.parsec.WFileChooser;
import java.awt.Component;
import java.io.File;

public abstract class FileSaveAction {
    private Component parent;

    protected File chooseSaveAsPath(File file, RefinedFileFilter refinedFileFilter) throws ParsecException {
        String string;
        String string2;
        String string3;
        WFileChooser wFileChooser = new WFileChooser(".");
        wFileChooser.setDialogType(1);
        wFileChooser.setAcceptAllFileFilterUsed(false);
        wFileChooser.addChoosableFileFilter(refinedFileFilter);
        int n = wFileChooser.showSaveDialog(this.parent);
        if (n != 0) {
            return null;
        }
        File file2 = wFileChooser.getSelectedFile();
        String string4 = file2.getPath();
        if (!string4.endsWith(string3 = refinedFileFilter.getExtensions()[0])) {
            file2 = new File(string4 + string3);
        }
        if (file2.exists() && !ParsecTools.showYesNoWarning(this.parent, string2 = "Save As", string = "The file already exists. Overwrite?")) {
            return null;
        }
        return file2;
    }

    protected File buildTempPath(File file) throws ParsecException {
        if (!file.canWrite()) {
            throw new GenericParsecException("File can't be written: " + file);
        }
        String string = file.getPath();
        int n = (int)(System.currentTimeMillis() % 65535L);
        File file2 = new File(String.format("%s.new-%04X", string, n));
        if (file2.exists()) {
            throw new GenericParsecException("Temporary file exists: " + file2);
        }
        return file2;
    }

    protected abstract void saveTo(File var1) throws ParsecException;

    protected void replaceFile(File file, File file2) throws ParsecException {
        int n;
        String string = file.getPath();
        String string2 = String.format("%s.bak-%04X", string, n = (int)(System.currentTimeMillis() % 65535L));
        File file3 = new File(string2);
        if (!file.renameTo(file3)) {
            if (!file.delete()) {
                throw new GenericParsecException("Can't (re-)move the current file: " + file);
            }
            file3 = null;
        }
        if (!file2.renameTo(file)) {
            throw new GenericParsecException("Can't move the new file: " + file2);
        }
        if (file3 != null && !file3.delete()) {
            throw new GenericParsecException("Can't remove the old file: " + file3);
        }
    }

    public FileSaveAction(Component component) {
        this.parent = component;
    }

    public File save(File file, RefinedFileFilter refinedFileFilter) {
        try {
            if (file == null) {
                File file2 = this.chooseSaveAsPath(file, refinedFileFilter);
                if (file2 == null) {
                    return null;
                }
                this.saveTo(file2);
                return file2;
            }
            File file3 = this.buildTempPath(file);
            if (file3 == null) {
                return null;
            }
            this.saveTo(file3);
            this.replaceFile(file, file3);
            return file;
        }
        catch (Throwable throwable) {
            String string = "File write error";
            ParsecTools.showExceptionDialog(this.parent, string, throwable);
            return null;
        }
    }
}

