/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.io.netscan;

import dexlogic.io.netscan.NetScanAddress;
import java.net.InetSocketAddress;

public class NetScanServer {
    Object hostID;
    String hostName;
    NetScanAddress[] addresses;
    InetSocketAddress defaultAddress;

    public NetScanServer(Object object, InetSocketAddress inetSocketAddress) {
        if (object == null) {
            throw new IllegalArgumentException("Invalid hostID parameter");
        }
        this.hostID = object;
        if (inetSocketAddress != null) {
            this.addresses = new NetScanAddress[1];
            this.addresses[0] = new NetScanAddress(inetSocketAddress);
            this.defaultAddress = inetSocketAddress;
        } else {
            this.addresses = new NetScanAddress[0];
            this.defaultAddress = null;
        }
    }

    public NetScanServer(Object object) {
        this(object, null);
    }

    public Object getHostID() {
        return this.hostID;
    }

    public String getHostName() {
        return this.hostName;
    }

    public boolean isReachable() {
        return this.defaultAddress != null;
    }

    public InetSocketAddress getDefaultAddress() {
        return this.defaultAddress;
    }

    public NetScanAddress[] getAddresses() {
        return this.addresses;
    }

    public boolean equals(Object object) {
        if (super.equals(object)) {
            return true;
        }
        return object instanceof NetScanServer && this.hostID.equals(((NetScanServer)object).hostID);
    }
}

