/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.io.netscan;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class NetScanQueue {
    ArrayList<Query> queryList = new ArrayList();

    NetScanQueue() {
    }

    boolean hasQueries() {
        return this.queryList.size() != 0;
    }

    int getQueryCount() {
        return this.queryList.size();
    }

    Query getNextQuery() {
        int n = this.queryList.size();
        if (n <= 0) {
            return null;
        }
        return this.queryList.remove(n - 1);
    }

    public void addQuery(ByteBuffer byteBuffer, InetSocketAddress inetSocketAddress) {
        if (byteBuffer != null && inetSocketAddress != null) {
            this.queryList.add(new Query(byteBuffer, inetSocketAddress));
        }
    }

    static class Query {
        InetSocketAddress socketAddress;
        ByteBuffer reqBuffer;

        Query(ByteBuffer byteBuffer, InetSocketAddress inetSocketAddress) {
            this.reqBuffer = byteBuffer;
            this.socketAddress = inetSocketAddress;
        }
    }
}

