/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.io.netscan;

import dexlogic.io.netscan.NetScanQueue;
import dexlogic.io.netscan.NetScanServer;
import dexlogic.io.netscan.NetScanTrace;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;

public class NetScanHandler {
    private HashMap<Object, NetScanServer> serverMap = new HashMap();

    protected String getProtocolName(int n) {
        return Integer.toString(n);
    }

    public void logDebug(NetScanTrace netScanTrace, InetSocketAddress inetSocketAddress, String string, Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(inetSocketAddress.getAddress().getHostAddress());
        stringBuilder.append("(").append(this.getProtocolName(inetSocketAddress.getPort())).append("): ");
        stringBuilder.append(string);
        netScanTrace.logDebug(stringBuilder.toString(), objectArray);
    }

    public void logError(NetScanTrace netScanTrace, InetSocketAddress inetSocketAddress, String string, Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(inetSocketAddress.getAddress().getHostAddress());
        stringBuilder.append("(").append(this.getProtocolName(inetSocketAddress.getPort())).append("): ");
        stringBuilder.append(string);
        netScanTrace.logError(stringBuilder.toString(), objectArray);
    }

    protected String getTaskName() {
        throw new UnsupportedOperationException("Not implemented");
    }

    protected int[] getPortNumbers() {
        throw new UnsupportedOperationException("Not implemented");
    }

    protected void prepareScan() {
    }

    protected void terminateScan() {
    }

    protected ByteBuffer getScanQuery() {
        return null;
    }

    protected ByteBuffer getCheckQuery() {
        return null;
    }

    protected NetScanServer readFindReply(NetScanTrace netScanTrace, ByteBuffer byteBuffer, InetSocketAddress inetSocketAddress) {
        return null;
    }

    protected void getChatQueries(NetScanQueue netScanQueue, InetSocketAddress inetSocketAddress) {
    }

    protected void readChatReply(NetScanTrace netScanTrace, ByteBuffer byteBuffer, InetSocketAddress inetSocketAddress, NetScanServer netScanServer) {
    }

    protected void setHostName(NetScanServer netScanServer, String string) {
        netScanServer.hostName = string;
    }

    protected String getIDString(NetScanServer netScanServer) {
        return null;
    }

    public void putServer(NetScanServer netScanServer) {
        this.serverMap.put(netScanServer.getHostID(), netScanServer);
    }

    public NetScanServer getServer(Object object) {
        return this.serverMap.get(object);
    }

    public NetScanServer[] getServers() {
        Collection<NetScanServer> collection = this.serverMap.values();
        return collection.toArray(new NetScanServer[collection.size()]);
    }

    public Collection<NetScanServer> getServerCollection() {
        return this.serverMap.values();
    }
}

