/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.io.idn.packets;

import dexlogic.io.idn.IDNDataException;
import dexlogic.io.idn.IDNServiceMap;
import dexlogic.io.idn.IDNTools;
import dexlogic.io.idn.packets.IDNPacket;
import java.nio.ByteBuffer;
import java.util.Iterator;

public class IDNServiceMapRspPacket
extends IDNPacket {
    private IDNServiceMap serviceMap = null;

    @Override
    protected void resetMembers() {
        super.resetMembers();
        this.serviceMap = null;
    }

    @Override
    protected void readBytes(ByteBuffer byteBuffer) throws IDNDataException {
        Object object;
        String string;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        super.readBytes(byteBuffer);
        if (byteBuffer.remaining() < 1) {
            throw new IDNDataException("ServiceMap response: Invalid length");
        }
        int n6 = byteBuffer.get(byteBuffer.position()) & 0xFF;
        if (n6 != 4) {
            throw new IDNDataException("ServiceMap response: Invalid header size " + n6);
        }
        if (byteBuffer.remaining() < n6) {
            throw new IDNDataException("ServiceMap response: Invalid packet size " + byteBuffer.remaining() + " < " + n6);
        }
        byteBuffer.position(byteBuffer.position() + 1);
        int n7 = byteBuffer.get() & 0xFF;
        int n8 = byteBuffer.get() & 0xFF;
        int n9 = byteBuffer.get() & 0xFF;
        int n10 = n8 + n9;
        if (n7 != 24) {
            throw new IDNDataException("ServiceMap response: Invalid entry struct size " + n7);
        }
        if (byteBuffer.remaining() != n10 * n7) {
            throw new IDNDataException("ServiceMap response: Invalid entry table " + byteBuffer.remaining() + " " + n10 + " " + n7);
        }
        IDNServiceMap iDNServiceMap = new IDNServiceMap();
        for (n5 = 0; n5 < n8; ++n5) {
            n4 = byteBuffer.get() & 0xFF;
            n3 = byteBuffer.get() & 0xFF;
            n2 = byteBuffer.get() & 0xFF;
            n = byteBuffer.get() & 0xFF;
            string = IDNTools.readStringField(byteBuffer, 20);
            if (n4 != 0) {
                throw new IDNDataException("ServiceMap response(relay): Invalid serviceID  " + n4);
            }
            if (n3 != 0) {
                throw new IDNDataException("ServiceMap response(relay): Invalid serviceType  " + n3);
            }
            if (n == 0) {
                throw new IDNDataException("ServiceMap response(relay): Invalid relayNumber  " + n);
            }
            object = new IDNServiceMap.RelayEntry(n, string);
            ((IDNServiceMap.RelayEntry)object).flags = n2;
            iDNServiceMap.addRelayEntry((IDNServiceMap.RelayEntry)object);
        }
        for (n5 = 0; n5 < n9; ++n5) {
            n4 = byteBuffer.get() & 0xFF;
            n3 = byteBuffer.get() & 0xFF;
            n2 = byteBuffer.get() & 0xFF;
            n = byteBuffer.get() & 0xFF;
            string = IDNTools.readStringField(byteBuffer, 20);
            if (n4 == 0) {
                throw new IDNDataException("ServiceMap response(service): Invalid serviceID  " + n4);
            }
            object = new IDNServiceMap.ServiceEntry(n4, string);
            ((IDNServiceMap.ServiceEntry)object).serviceType = n3;
            ((IDNServiceMap.ServiceEntry)object).flags = n2;
            int n11 = iDNServiceMap.addServiceEntry((IDNServiceMap.ServiceEntry)object, n);
            if (n11 >= 0) continue;
            throw new IDNDataException("ServiceMap response(service): Invalid relayNumber  " + n);
        }
        this.serviceMap = iDNServiceMap;
        byteBuffer.mark();
    }

    @Override
    protected void writeBytes(ByteBuffer byteBuffer) throws IDNDataException {
        Object object;
        super.writeBytes(byteBuffer);
        byteBuffer.put((byte)4);
        byteBuffer.put((byte)24);
        int n = byteBuffer.position();
        byteBuffer.put((byte)0);
        int n2 = byteBuffer.position();
        byteBuffer.put((byte)0);
        int n3 = 0;
        if (this.serviceMap != null) {
            Iterator<IDNServiceMap.RelayEntry> iterator = this.serviceMap.relayIterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                byteBuffer.put((byte)0);
                byteBuffer.put((byte)0);
                byteBuffer.put((byte)((IDNServiceMap.RelayEntry)object).flags);
                byteBuffer.put((byte)((IDNServiceMap.RelayEntry)object).relayNumber);
                IDNTools.writeStringField(byteBuffer, ((IDNServiceMap.RelayEntry)object).relayName, 20);
                ++n3;
            }
        }
        int n4 = 0;
        if (this.serviceMap != null) {
            object = this.serviceMap.serviceIterator();
            while (object.hasNext()) {
                IDNServiceMap.ServiceEntry serviceEntry = (IDNServiceMap.ServiceEntry)object.next();
                IDNServiceMap.RelayEntry relayEntry = serviceEntry.parentRelay;
                int n5 = relayEntry != null ? relayEntry.relayNumber : 0;
                byteBuffer.put((byte)serviceEntry.serviceID);
                byteBuffer.put((byte)serviceEntry.serviceType);
                byteBuffer.put((byte)serviceEntry.flags);
                byteBuffer.put((byte)n5);
                IDNTools.writeStringField(byteBuffer, serviceEntry.serviceName, 20);
                ++n4;
            }
        }
        byteBuffer.put(n, (byte)n3);
        byteBuffer.put(n2, (byte)n4);
        byteBuffer.mark();
    }

    public IDNServiceMapRspPacket() {
        super(19);
    }

    public void setServiceMap(IDNServiceMap iDNServiceMap) {
        this.serviceMap = iDNServiceMap;
    }

    public IDNServiceMap getServiceMap() {
        return this.serviceMap;
    }

    @Override
    public String toString() {
        return String.format("IDNServiceMapRspPacket", new Object[0]);
    }
}

