/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.io.idn.packets;

import dexlogic.io.idn.IDNDataException;
import dexlogic.io.idn.IDNTools;
import dexlogic.io.idn.IDNUnitID;
import dexlogic.io.idn.packets.IDNPacket;
import java.nio.ByteBuffer;

public class IDNScanRspPacket
extends IDNPacket {
    private int protocolVersion;
    private int status;
    private IDNUnitID unitID;
    private String hostName;

    @Override
    protected void resetMembers() {
        super.resetMembers();
        this.unitID = null;
        this.hostName = null;
    }

    @Override
    protected void readBytes(ByteBuffer byteBuffer) throws IDNDataException {
        super.readBytes(byteBuffer);
        if (byteBuffer.remaining() < 1) {
            throw new IDNDataException("Scan response: Invalid length");
        }
        int n = byteBuffer.get(byteBuffer.position()) & 0xFF;
        if (n != 36 && n != 40) {
            throw new IDNDataException("Scan response: Invalid header size " + n);
        }
        if (byteBuffer.remaining() < n) {
            throw new IDNDataException("Scan response: Invalid packet size " + byteBuffer.remaining() + " < " + n);
        }
        byteBuffer.position(byteBuffer.position() + 1);
        this.protocolVersion = byteBuffer.get() & 0xFF;
        this.status = byteBuffer.get() & 0xFF;
        int n2 = byteBuffer.get() & 0xFF;
        this.unitID = IDNTools.readUnitIDField(byteBuffer, 16);
        this.hostName = IDNTools.readStringField(byteBuffer, n == 36 ? 16 : 20);
        byteBuffer.mark();
    }

    @Override
    protected void writeBytes(ByteBuffer byteBuffer) throws IDNDataException {
        super.writeBytes(byteBuffer);
        byteBuffer.put((byte)40);
        byteBuffer.put((byte)this.protocolVersion);
        byteBuffer.put((byte)this.status);
        byteBuffer.put((byte)0);
        IDNTools.writeUnitIDField(byteBuffer, this.unitID, 16);
        IDNTools.writeStringField(byteBuffer, this.hostName, 20);
        byteBuffer.mark();
    }

    public IDNScanRspPacket() {
        super(17);
        this.unitID = this.unitID;
    }

    public void setProtocolVersion(int n) {
        this.protocolVersion = n;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public int getStatus() {
        return this.status;
    }

    public void setUnitID(IDNUnitID iDNUnitID) {
        this.unitID = iDNUnitID;
    }

    public IDNUnitID getUnitID() {
        return this.unitID;
    }

    public void setHostName(String string) {
        this.hostName = string;
    }

    public String getHostName() {
        return this.hostName;
    }

    @Override
    public String toString() {
        return String.format("IDNScanRspPacket", new Object[0]);
    }
}

