/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.io.idn.messages;

import dexlogic.io.idn.IDNDataException;
import dexlogic.io.idn.messages.IDNFileLocatorMessage;
import java.nio.ByteBuffer;

public class IDNFile64LocatorMessage
extends IDNFileLocatorMessage {
    @Override
    protected void setContentID(int n) {
        if (n != 14468) {
            throw new RuntimeException("ContentID mismatch");
        }
    }

    @Override
    protected void readBytes(ByteBuffer byteBuffer) throws IDNDataException {
        super.readBytes(byteBuffer);
        byteBuffer.getInt();
        this.nextLocatorFP = byteBuffer.getLong();
        if (byteBuffer.remaining() == 0 || byteBuffer.remaining() % 8 != 0) {
            throw new IDNDataException("Invalid locator table");
        }
        int n = byteBuffer.remaining() / 8;
        this.locatorTable = new long[n];
        for (int i = 0; i < n; ++i) {
            this.locatorTable[i] = byteBuffer.getLong();
        }
        byteBuffer.mark();
    }

    @Override
    protected void writeBytes(ByteBuffer byteBuffer) throws IDNDataException {
        super.writeBytes(byteBuffer);
        byteBuffer.putInt(0);
        byteBuffer.putLong(this.nextLocatorFP);
        if (this.locatorTable == null) {
            throw new IDNDataException("Invalid locator table");
        }
        int n = this.locatorTable.length;
        for (int i = 0; i < n; ++i) {
            byteBuffer.putLong(this.locatorTable[i]);
        }
        byteBuffer.mark();
    }

    @Override
    public int getContentID() {
        return 14468;
    }

    @Override
    public String toString() {
        return String.format("IDNFile64LocatorMessage", new Object[0]);
    }
}

