/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.io.idn.messages;

import dexlogic.io.idn.IDNDataException;
import dexlogic.io.idn.IDNTools;
import dexlogic.io.idn.messages.IDNFileAnchorMessage;
import dexlogic.io.idn.structs.IDNFile64TrackEntryStruct;
import dexlogic.io.idn.structs.IDNFileTrackEntryStruct;
import java.nio.ByteBuffer;

public class IDNFile64AnchorMessage
extends IDNFileAnchorMessage {
    @Override
    protected void setContentID(int n) {
        if (n != 14464) {
            throw new RuntimeException("ContentID mismatch");
        }
    }

    @Override
    protected void readBytes(ByteBuffer byteBuffer) throws IDNDataException {
        super.readBytes(byteBuffer);
        this.streamName = IDNTools.readStringField(byteBuffer, 20);
        this.nextAnchorFP = byteBuffer.getLong();
        long l = byteBuffer.getLong();
        long l2 = byteBuffer.getLong();
        this.durationMS = (long)byteBuffer.getInt() & 0xFFFFFFFFFFFFFFFFL;
        byteBuffer.getInt();
        byteBuffer.getLong();
        byteBuffer.getLong();
        byteBuffer.getLong();
        byteBuffer.getLong();
        byteBuffer.getLong();
        this.movieFirstFP = byteBuffer.getLong();
        this.movieLastFP = byteBuffer.getLong();
        this.movieLength = byteBuffer.getLong();
        this.movieLocatorFP = byteBuffer.getLong();
        while (byteBuffer.remaining() != 0) {
            int n = byteBuffer.position();
            int n2 = 64;
            ByteBuffer byteBuffer2 = byteBuffer.slice();
            byteBuffer2.limit(n2);
            IDNFile64TrackEntryStruct iDNFile64TrackEntryStruct = new IDNFile64TrackEntryStruct();
            iDNFile64TrackEntryStruct.readFrom(byteBuffer2);
            this.trackEntries.add(iDNFile64TrackEntryStruct);
            byteBuffer.position(n + n2);
        }
        byteBuffer.mark();
    }

    @Override
    protected void writeBytes(ByteBuffer byteBuffer) throws IDNDataException {
        super.writeBytes(byteBuffer);
        IDNTools.writeStringField(byteBuffer, this.streamName, 20);
        byteBuffer.putLong(this.nextAnchorFP);
        byteBuffer.putLong(0L);
        byteBuffer.putLong(0L);
        byteBuffer.putInt((int)this.durationMS);
        byteBuffer.putInt(0);
        byteBuffer.putLong(0L);
        byteBuffer.putLong(0L);
        byteBuffer.putLong(0L);
        byteBuffer.putLong(0L);
        byteBuffer.putLong(0L);
        byteBuffer.putLong(this.movieFirstFP);
        byteBuffer.putLong(this.movieLastFP);
        byteBuffer.putLong(this.movieLength);
        byteBuffer.putLong(this.movieLocatorFP);
        int n = this.trackEntries.size();
        for (int i = 0; i < n; ++i) {
            IDNFileTrackEntryStruct iDNFileTrackEntryStruct = (IDNFileTrackEntryStruct)this.trackEntries.get(i);
            if (!(iDNFileTrackEntryStruct instanceof IDNFile64TrackEntryStruct)) {
                throw new IDNDataException("Track entry type mismatch (not File64)");
            }
            iDNFileTrackEntryStruct.writeTo(byteBuffer);
        }
        byteBuffer.mark();
    }

    @Override
    public int getContentID() {
        return 14464;
    }

    @Override
    public String toString() {
        return String.format("IDNFile64AnchorMessage", new Object[0]);
    }
}

