/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.io.idn;

import dexlogic.io.idn.IDNUnitID;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public class IDNTools {
    private static char encodeHex(int n) {
        if ((n &= 0xF) < 10) {
            return (char)(48 + n);
        }
        return (char)(65 + (n - 10));
    }

    public static String readStringField(ByteBuffer byteBuffer, int n) {
        int n2;
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        for (n2 = n; n2 > 0 && byArray[n2 - 1] <= 32; --n2) {
        }
        for (int i = 0; i < n2; ++i) {
            if (byArray[i] != 0) continue;
            n2 = i;
            break;
        }
        String string = null;
        if (n2 != 0) {
            string = new String(byArray, 0, n2, StandardCharsets.UTF_8);
        }
        return string;
    }

    public static IDNUnitID readUnitIDField(ByteBuffer byteBuffer, int n) {
        int n2;
        if (n < 1) {
            throw new IllegalArgumentException("Invalid field size " + n);
        }
        int n3 = byteBuffer.get() & 0xFF;
        if (n3 > --n) {
            return null;
        }
        byte[] byArray = new byte[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            byArray[n2] = byteBuffer.get();
        }
        for (n2 = n3; n2 < n; ++n2) {
            byteBuffer.get();
        }
        return new IDNUnitID(byArray);
    }

    public static void writeByteField(ByteBuffer byteBuffer, byte[] byArray, int n) {
        if (byArray != null) {
            int n2 = byArray.length;
            for (int i = 0; i < n2 && n > 0; ++i, --n) {
                byteBuffer.put(byArray[i]);
            }
        }
        while (n > 0) {
            byteBuffer.put((byte)0);
            --n;
        }
    }

    public static void writeStringField(ByteBuffer byteBuffer, String string, int n) {
        byte[] byArray = null;
        while (true) {
            if (string != null) {
                byArray = string.getBytes(StandardCharsets.UTF_8);
            }
            if (byArray == null || byArray.length < n) break;
            byArray = null;
            string = string.substring(0, string.length() - 1);
        }
        IDNTools.writeByteField(byteBuffer, byArray, n);
    }

    public static void writeUnitIDField(ByteBuffer byteBuffer, IDNUnitID iDNUnitID, int n) {
        byte[] byArray;
        byte[] byArray2 = byArray = iDNUnitID != null ? iDNUnitID.getIDBytes() : null;
        if (byArray != null && n <= byArray.length + 1) {
            throw new IllegalArgumentException("UnitID too long " + byArray.length);
        }
        if (byArray == null) {
            while (n > 0) {
                byteBuffer.put((byte)0);
                --n;
            }
        } else {
            byteBuffer.put((byte)byArray.length);
            IDNTools.writeByteField(byteBuffer, byArray, --n);
        }
    }

    public static void dump(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            int n3;
            if (i % 16 == 0) {
                System.out.print(IDNTools.encodeHex(i >> 12));
                System.out.print(IDNTools.encodeHex(i >> 8));
                System.out.print(IDNTools.encodeHex(i >> 4));
                System.out.print(IDNTools.encodeHex(i));
                System.out.print("  ");
            }
            if ((n3 = byArray[n + i] & 0xFF) >= 32 && n3 < 128) {
                stringBuffer.append((char)n3);
            } else {
                stringBuffer.append('.');
            }
            System.out.print(IDNTools.encodeHex(n3 >> 4));
            System.out.print(IDNTools.encodeHex(n3));
            System.out.print(" ");
            if ((i + 1) % 8 == 0 && (i + 1) % 16 != 0) {
                System.out.print("  ");
            }
            if ((i + 1) % 16 == 0) {
                System.out.println("   " + stringBuffer);
                stringBuffer.setLength(0);
                continue;
            }
            if (i + 1 != n2) continue;
            int n4 = 15 - i % 16;
            if (n4 > 8) {
                System.out.print("  ");
            }
            for (int j = 0; j < n4; ++j) {
                System.out.print("   ");
            }
            System.out.println("   " + stringBuffer);
            stringBuffer.setLength(0);
        }
    }

    public static void dump(ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit() - n;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n2; ++i) {
            int n3;
            if (i % 16 == 0) {
                System.out.print(IDNTools.encodeHex(i >> 12));
                System.out.print(IDNTools.encodeHex(i >> 8));
                System.out.print(IDNTools.encodeHex(i >> 4));
                System.out.print(IDNTools.encodeHex(i));
                System.out.print("  ");
            }
            if ((n3 = byteBuffer.get(n + i) & 0xFF) >= 32 && n3 < 128) {
                stringBuilder.append((char)n3);
            } else {
                stringBuilder.append('.');
            }
            System.out.print(IDNTools.encodeHex(n3 >> 4));
            System.out.print(IDNTools.encodeHex(n3));
            System.out.print(" ");
            if ((i + 1) % 8 == 0 && (i + 1) % 16 != 0) {
                System.out.print("  ");
            }
            if ((i + 1) % 16 == 0) {
                System.out.println("   " + stringBuilder);
                stringBuilder.setLength(0);
                continue;
            }
            if (i + 1 != n2) continue;
            int n4 = 15 - i % 16;
            if (n4 > 8) {
                System.out.print("  ");
            }
            for (int j = 0; j < n4; ++j) {
                System.out.print("   ");
            }
            System.out.println("   " + stringBuilder);
            stringBuilder.setLength(0);
        }
    }

    public static String toLongHexString(long l) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(IDNTools.encodeHex((byte)(l >> 60)));
        stringBuilder.append(IDNTools.encodeHex((byte)(l >> 56)));
        stringBuilder.append(IDNTools.encodeHex((byte)(l >> 52)));
        stringBuilder.append(IDNTools.encodeHex((byte)(l >> 48)));
        stringBuilder.append(IDNTools.encodeHex((byte)(l >> 44)));
        stringBuilder.append(IDNTools.encodeHex((byte)(l >> 40)));
        stringBuilder.append(IDNTools.encodeHex((byte)(l >> 36)));
        stringBuilder.append(IDNTools.encodeHex((byte)(l >> 32)));
        stringBuilder.append(IDNTools.encodeHex((byte)(l >> 28)));
        stringBuilder.append(IDNTools.encodeHex((byte)(l >> 24)));
        stringBuilder.append(IDNTools.encodeHex((byte)(l >> 20)));
        stringBuilder.append(IDNTools.encodeHex((byte)(l >> 16)));
        stringBuilder.append(IDNTools.encodeHex((byte)(l >> 12)));
        stringBuilder.append(IDNTools.encodeHex((byte)(l >> 8)));
        stringBuilder.append(IDNTools.encodeHex((byte)(l >> 4)));
        stringBuilder.append(IDNTools.encodeHex((byte)(l >> 0)));
        return stringBuilder.toString();
    }

    public static String toIntHexString(long l) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(IDNTools.encodeHex((byte)(l >> 28)));
        stringBuilder.append(IDNTools.encodeHex((byte)(l >> 24)));
        stringBuilder.append(IDNTools.encodeHex((byte)(l >> 20)));
        stringBuilder.append(IDNTools.encodeHex((byte)(l >> 16)));
        stringBuilder.append(IDNTools.encodeHex((byte)(l >> 12)));
        stringBuilder.append(IDNTools.encodeHex((byte)(l >> 8)));
        stringBuilder.append(IDNTools.encodeHex((byte)(l >> 4)));
        stringBuilder.append(IDNTools.encodeHex((byte)(l >> 0)));
        return stringBuilder.toString();
    }

    public static String toShortHexString(long l) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(IDNTools.encodeHex((byte)(l >> 12)));
        stringBuilder.append(IDNTools.encodeHex((byte)(l >> 8)));
        stringBuilder.append(IDNTools.encodeHex((byte)(l >> 4)));
        stringBuilder.append(IDNTools.encodeHex((byte)(l >> 0)));
        return stringBuilder.toString();
    }

    public static String toByteHexString(long l) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(IDNTools.encodeHex((byte)(l >> 4)));
        stringBuilder.append(IDNTools.encodeHex((byte)(l >> 0)));
        return stringBuilder.toString();
    }
}

