/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.io.idn;

import dexlogic.io.idn.IDNException;
import dexlogic.io.idn.IDNTools;
import dexlogic.io.idn.messages.IDNFile64AnchorMessage;
import dexlogic.io.idn.messages.IDNFile64LocatorMessage;
import dexlogic.io.idn.messages.IDNFileAnchorMessage;
import dexlogic.io.idn.messages.IDNFileLocatorMessage;
import dexlogic.io.idn.messages.IDNFileMessage;
import dexlogic.io.idn.messages.IDNMessage;
import dexlogic.io.idn.structs.IDNFileTrackEntryStruct;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;

public class IDNFile {
    private String filename;
    private RandomAccessFile file;
    private ByteBuffer msgByteBuffer;

    private String toFPHexString(long l) {
        return IDNTools.toIntHexString(l);
    }

    private void createFormatHeader() throws IOException, IDNException {
        int n;
        this.file.write(73);
        this.file.write(68);
        this.file.write(78);
        this.file.write(58);
        for (n = 0; n < 12; ++n) {
            this.file.write(32);
        }
        for (n = 0; n < 16; ++n) {
            this.file.write(32);
        }
        for (n = 0; n < 16; ++n) {
            this.file.write(32);
        }
        for (n = 0; n < 16; ++n) {
            this.file.write(32);
        }
        this.file.write(26);
        this.file.write(26);
        this.file.write(1);
        this.file.write(1);
        for (n = 0; n < 4; ++n) {
            this.file.write(0);
        }
        this.file.writeLong(System.currentTimeMillis());
        this.file.writeLong(0L);
        this.file.writeLong(0L);
        this.file.writeLong(0L);
        this.file.writeLong(0L);
        for (n = 0; n < 16; ++n) {
            this.file.write(0);
        }
    }

    private void checkFormatHeader() throws IOException, IDNException {
        if (this.file.length() < 128L) {
            String string = String.format("Invalid file length: %d", this.file.length());
            throw new IOException(string);
        }
        this.file.seek(0L);
        int n = this.file.readUnsignedByte();
        int n2 = this.file.readUnsignedByte();
        int n3 = this.file.readUnsignedByte();
        int n4 = this.file.readUnsignedByte();
        if (n != 73 || n2 != 68 || n3 != 78 || n4 != 58) {
            String string = String.format("Invalid signature: %02X %02X %02X %02X", n, n2, n3, n4);
            throw new IOException(string);
        }
        this.file.seek(64L);
        int n5 = this.file.readUnsignedByte();
        int n6 = this.file.readUnsignedByte();
        if (n5 != 26 || n6 != 26) {
            String string = String.format("Invalid delimiter: %02X %02X", n5, n6);
            throw new IOException(string);
        }
        int n7 = this.file.readUnsignedByte();
        int n8 = this.file.readUnsignedByte();
        if (n7 != 1 || n8 != 1) {
            String string = String.format("File format/version mismatch: %02X %02X", n7, n8);
            throw new IOException(string);
        }
    }

    private long seekNextChannelMessage(long l, long l2) throws IOException, IDNException {
        while (true) {
            if (l > l2) {
                return 0L;
            }
            this.file.seek(l);
            int n = this.file.readUnsignedShort();
            int n2 = this.file.readUnsignedShort();
            if ((n2 & 0x8000) != 0) break;
            l += (long)n;
        }
        this.file.seek(l);
        return l;
    }

    private void dumpMovie(IDNFileAnchorMessage iDNFileAnchorMessage) throws IOException, IDNException {
        long l = iDNFileAnchorMessage.getMovieFirstFP();
        long l2 = iDNFileAnchorMessage.getMovieLastFP();
        long l3 = iDNFileAnchorMessage.getMovieLength();
        this.file.seek(l);
        int n = this.file.readUnsignedShort();
        int n2 = this.file.readUnsignedShort();
        boolean bl = n2 == 14357;
        this.file.seek(l2);
        n = this.file.readUnsignedShort();
        n2 = this.file.readUnsignedShort();
        boolean bl2 = n2 == 14359;
        String string = "no beacons";
        if (bl && bl2) {
            string = "has beacons";
        } else if (bl != bl2) {
            string = "beacon mismatch";
        }
        String string2 = " ** Invalid";
        if (l2 - l + (long)n == l3) {
            string2 = " - OK";
        }
        System.out.printf("  Movie first 0x%s, last 0x%s, length %d%s, %s\n", this.toFPHexString(l), this.toFPHexString(l2), l3, string2, string);
        long l4 = this.seekNextChannelMessage(l, l2);
        if (l4 <= 0L) {
            throw new IDNException("Movie has no channel message");
        }
        n = this.file.readUnsignedShort();
        n2 = this.file.readUnsignedShort();
        long l5 = (long)this.file.readInt() & 0xFFFFFFFFFFFFFFFFL;
        long l6 = iDNFileAnchorMessage.getMovieLocatorFP();
        int n3 = 0;
        boolean bl3 = true;
        while (l6 != 0L) {
            long l7;
            IDNFileLocatorMessage iDNFileLocatorMessage = this.getLocatorMessageAt(l6);
            long[] lArray = iDNFileLocatorMessage.getLocatorTable();
            if (lArray == null || lArray.length == 0) {
                throw new IDNException("Empty locator table");
            }
            long l8 = iDNFileLocatorMessage.getNextLocatorFP();
            boolean bl4 = l8 == 0L;
            String string3 = "";
            if (bl3) {
                if (lArray[0] != l4) {
                    throw new IDNException("First locator entry (0x" + this.toFPHexString(lArray[0]) + ") invalid: Not pointing to first channel message (0x" + this.toFPHexString(l4) + ")");
                }
                string3 = ", first(OK)";
            }
            String string4 = "";
            if (bl4) {
                long l9 = lArray[lArray.length - 1];
                this.file.seek(l9);
                n = this.file.readUnsignedShort();
                n2 = this.file.readUnsignedShort();
                if ((n2 & 0x8000) == 0) {
                    throw new IDNException("Last locator entry (0x" + this.toFPHexString(lArray[0]) + ") invalid: Not a channel message");
                }
                l7 = this.seekNextChannelMessage(l9 + (long)n, l2);
                if (l7 > 0L) {
                    throw new IDNException("Last locator entry followed by channel message");
                }
                string4 = ", last(OK)";
            }
            System.out.printf("  Locator at 0x%s, %d entries%s%s\n", this.toFPHexString(l6), lArray.length, string3, string4);
            for (int i = 0; i < 10 && i < lArray.length; ++i) {
                int n4 = n3 + i;
                l7 = l5 + (long)n4 * 1000000L & 0xFFFFFFFFFFFFFFFFL;
                String string5 = "";
            }
            bl3 = false;
            n3 += lArray.length;
            l6 = l8;
        }
    }

    private void dumpAnchor(long l, IDNFileAnchorMessage iDNFileAnchorMessage) throws IOException, IDNException {
        System.out.printf("Anchor 0x%s: %s, duration=%d ms\n", this.toFPHexString(l), iDNFileAnchorMessage.getStreamName(), iDNFileAnchorMessage.getDurationMS());
        Iterator<IDNFileTrackEntryStruct> iterator = iDNFileAnchorMessage.trackIterator();
        while (iterator.hasNext()) {
            IDNFileTrackEntryStruct iDNFileTrackEntryStruct = iterator.next();
            System.out.printf("  ServiceID %3d, type 0x%02X, flags 0x%02X, %s\n", iDNFileTrackEntryStruct.getServiceID(), iDNFileTrackEntryStruct.getServiceType(), iDNFileTrackEntryStruct.getFlags(), iDNFileTrackEntryStruct.getTrackName());
        }
        if (iDNFileAnchorMessage.getMovieFirstFP() != 0L) {
            this.dumpMovie(iDNFileAnchorMessage);
        }
    }

    public IDNFile(String string) {
        this.filename = string;
        this.msgByteBuffer = ByteBuffer.allocate(65536);
    }

    public String getName() {
        return this.filename;
    }

    public void open(String string) throws IOException, IDNException {
        if (this.filename == null || this.filename.length() == 0) {
            String string2 = String.format("Invalid filename <%s>", this.filename);
            throw new IOException(string2);
        }
        if (string == null || !string.equals("r") && !string.equals("rw") && !string.equals("rws") && !string.equals("rwd")) {
            String string3 = String.format("Invalid mode <%s>", string);
            throw new IOException(string3);
        }
        try {
            this.file = new RandomAccessFile(this.filename, string);
            if (this.file.length() > 0L) {
                this.checkFormatHeader();
            } else {
                if (string.equals("r")) {
                    throw new IOException("Read on empty file");
                }
                this.createFormatHeader();
            }
        }
        catch (Throwable throwable) {
            if (this.file != null) {
                try {
                    this.file.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.file = null;
            }
            throw throwable;
        }
    }

    public void close() throws IOException {
        if (this.file != null) {
            this.file.close();
        }
        this.file = null;
    }

    public IDNMessage getMessageAt(long l) throws IOException, IDNException {
        this.file.seek(l);
        int n = this.file.readUnsignedShort();
        int n2 = this.file.readUnsignedShort();
        this.file.seek(l);
        this.msgByteBuffer.rewind();
        this.file.read(this.msgByteBuffer.array(), this.msgByteBuffer.arrayOffset(), n);
        this.msgByteBuffer.limit(n);
        IDNFileMessage iDNFileMessage = null;
        if (n2 == 14464) {
            iDNFileMessage = new IDNFile64AnchorMessage();
        } else if (n2 == 14468) {
            iDNFileMessage = new IDNFile64LocatorMessage();
        } else {
            String string = String.format("Unsupported contentID 0x%04X", n2);
            throw new IDNException(string);
        }
        iDNFileMessage.readFrom(this.msgByteBuffer);
        return iDNFileMessage;
    }

    public IDNFileAnchorMessage getAnchorMessageAt(long l) throws IOException, IDNException {
        if (l == 0L) {
            return null;
        }
        IDNMessage iDNMessage = this.getMessageAt(l);
        if (iDNMessage instanceof IDNFileAnchorMessage) {
            return (IDNFileAnchorMessage)iDNMessage;
        }
        String string = this.toFPHexString(l);
        String string2 = iDNMessage.toString();
        String string3 = String.format("Content error fp=0x%s: Expected Anchor, got %s", string, string2);
        throw new IDNException(string3);
    }

    public IDNFileAnchorMessage getFirstAnchorMessage() throws IOException, IDNException {
        this.file.seek(96L);
        long l = this.file.readLong();
        if (l == 0L) {
            return null;
        }
        return this.getAnchorMessageAt(l);
    }

    public IDNFileLocatorMessage getLocatorMessageAt(long l) throws IOException, IDNException {
        if (l == 0L) {
            return null;
        }
        IDNMessage iDNMessage = this.getMessageAt(l);
        if (iDNMessage instanceof IDNFileLocatorMessage) {
            return (IDNFileLocatorMessage)iDNMessage;
        }
        String string = this.toFPHexString(l);
        String string2 = iDNMessage.toString();
        String string3 = String.format("Content error fp=0x%s: Expected Locator, got %s", string, string2);
        throw new IDNException(string3);
    }

    public void checkStructure() throws IOException, IDNException {
        int n;
        this.file.seek(4L);
        byte[] byArray = new byte[60];
        this.file.readFully(byArray);
        for (n = byArray.length; n > 0 && byArray[n - 1] <= 32; --n) {
        }
        String string = new String(byArray, 0, n, StandardCharsets.UTF_8);
        System.out.printf("Title: %s\n", string);
        this.file.seek(66L);
        int n2 = this.file.readUnsignedByte();
        int n3 = this.file.readUnsignedByte();
        this.file.seek(72L);
        long l = this.file.readLong();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String string2 = simpleDateFormat.format(new Date(l));
        System.out.printf("Creation(UTC): %s, format %d, version %d\n", string2, n2, n3);
        this.file.seek(96L);
        long l2 = this.file.readLong();
        while (l2 != 0L) {
            IDNFileAnchorMessage iDNFileAnchorMessage = this.getAnchorMessageAt(l2);
            this.dumpAnchor(l2, iDNFileAnchorMessage);
            l2 = iDNFileAnchorMessage.getNextAnchorFP();
        }
    }
}

