/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.io.dln.packets;

import dexlogic.io.dln.DLNDataException;
import java.nio.ByteBuffer;

public class DLNPacket {
    private int command = 0;
    private int sequence = 0;

    protected void resetMembers() {
        this.command = 0;
        this.sequence = 0;
    }

    protected void readBytes(ByteBuffer byteBuffer) throws DLNDataException {
        this.command = byteBuffer.get() & 0xFF;
        int n = byteBuffer.get() & 0xFF;
        this.sequence = byteBuffer.getShort() & 0xFFFF;
        byteBuffer.mark();
    }

    protected void writeBytes(ByteBuffer byteBuffer) throws DLNDataException {
        byteBuffer.put((byte)this.command);
        byteBuffer.put((byte)0);
        byteBuffer.putShort((short)this.sequence);
        byteBuffer.mark();
    }

    public DLNPacket(int n) {
        this.command = n;
    }

    public int getCommand() {
        return this.command;
    }

    public void setSequence(int n) {
        this.sequence = n;
    }

    public int getSequence() {
        return this.sequence;
    }

    public void readFrom(ByteBuffer byteBuffer) throws DLNDataException {
        this.resetMembers();
        byteBuffer.rewind();
        this.readBytes(byteBuffer);
    }

    public ByteBuffer writeTo(ByteBuffer byteBuffer) throws DLNDataException {
        byteBuffer.clear();
        this.writeBytes(byteBuffer);
        int n = byteBuffer.position();
        byteBuffer.limit(n);
        return byteBuffer;
    }

    public ByteBuffer writeTo(ByteBuffer byteBuffer, int n) throws DLNDataException {
        this.sequence = n;
        return this.writeTo(byteBuffer);
    }

    public String toString() {
        return String.format("DLNPacket %02X", this.command);
    }
}

