/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.io.dln.packets;

import dexlogic.io.dln.DLNCaptureMap;
import dexlogic.io.dln.DLNDataException;
import dexlogic.io.dln.DLNTools;
import dexlogic.io.dln.packets.DLNPacket;
import java.nio.ByteBuffer;
import java.util.Iterator;

public class DLNCaptureMapRspPacket
extends DLNPacket {
    private DLNCaptureMap captureMap = null;

    @Override
    protected void resetMembers() {
        super.resetMembers();
        this.captureMap = null;
    }

    @Override
    protected void readBytes(ByteBuffer byteBuffer) throws DLNDataException {
        int n;
        super.readBytes(byteBuffer);
        if (byteBuffer.remaining() < 1) {
            throw new DLNDataException("CaptureMap response: Invalid length");
        }
        int n2 = byteBuffer.get(byteBuffer.position()) & 0xFF;
        if (n2 != 4) {
            throw new DLNDataException("CaptureMap response: Invalid header size " + n2);
        }
        if (byteBuffer.remaining() < n2) {
            throw new DLNDataException("CaptureMap response: Invalid packet size " + byteBuffer.remaining() + " < " + n2);
        }
        byteBuffer.position(byteBuffer.position() + 1);
        int n3 = byteBuffer.get() & 0xFF;
        int n4 = byteBuffer.get() & 0xFF;
        int n5 = n = byteBuffer.get() & 0xFF;
        if (n3 != 24) {
            throw new DLNDataException("CaptureMap response: Invalid entry struct size " + n3);
        }
        if (byteBuffer.remaining() != n5 * n3) {
            throw new DLNDataException("CaptureMap response: Invalid entry table " + byteBuffer.remaining() + " " + n5 + " " + n3);
        }
        DLNCaptureMap dLNCaptureMap = new DLNCaptureMap();
        for (int i = 0; i < n; ++i) {
            int n6 = byteBuffer.get() & 0xFF;
            int n7 = byteBuffer.get() & 0xFF;
            int n8 = byteBuffer.get() & 0xFF;
            int n9 = byteBuffer.get() & 0xFF;
            String string = DLNTools.readStringField(byteBuffer, 20);
            if (n6 == 0) {
                throw new DLNDataException("CaptureMap response(service): Invalid captureID  " + n6);
            }
            DLNCaptureMap.CaptureEntry captureEntry = new DLNCaptureMap.CaptureEntry(n6, string);
            captureEntry.captureType = n7;
            captureEntry.flags = n8;
            int n10 = dLNCaptureMap.addCaptureEntry(captureEntry);
            if (n10 >= 0) continue;
            throw new DLNDataException("CaptureMap response(capture): Failed to add capture entry");
        }
        this.captureMap = dLNCaptureMap;
        byteBuffer.mark();
    }

    @Override
    protected void writeBytes(ByteBuffer byteBuffer) throws DLNDataException {
        super.writeBytes(byteBuffer);
        byteBuffer.put((byte)4);
        byteBuffer.put((byte)24);
        byteBuffer.put((byte)0);
        int n = byteBuffer.position();
        byteBuffer.put((byte)0);
        int n2 = 0;
        if (this.captureMap != null) {
            Iterator<DLNCaptureMap.CaptureEntry> iterator = this.captureMap.captureIterator();
            while (iterator.hasNext()) {
                DLNCaptureMap.CaptureEntry captureEntry = iterator.next();
                if (captureEntry.captureID < 1 || captureEntry.captureID > 255) {
                    throw new DLNDataException("Invalid captureID " + captureEntry.captureID);
                }
                byteBuffer.put((byte)captureEntry.captureID);
                byteBuffer.put((byte)captureEntry.captureType);
                byteBuffer.put((byte)captureEntry.flags);
                byteBuffer.put((byte)0);
                DLNTools.writeStringField(byteBuffer, captureEntry.captureName, 20);
                ++n2;
            }
        }
        byteBuffer.put(n, (byte)n2);
        byteBuffer.mark();
    }

    public DLNCaptureMapRspPacket() {
        super(19);
    }

    public void setCaptureMap(DLNCaptureMap dLNCaptureMap) {
        this.captureMap = dLNCaptureMap;
    }

    public DLNCaptureMap getCaptureMap() {
        return this.captureMap;
    }

    @Override
    public String toString() {
        return String.format("DLNCaptureMapRspPacket", new Object[0]);
    }
}

