/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.idnFileCheck;

import dexlogic.idnFileCheck.IDNFile64Anchor;
import dexlogic.idnFileCheck.TestEnvironment;
import dexlogic.idnFileCheck.TestException;
import dexlogic.idnFileCheck.TestScope;
import dexlogic.idnFileCheck.TestTools;

public class IDNFile64Locator {
    long locatorFP;
    int locNum;
    int locatorTime;
    IDNFile64Anchor anchorMsg;
    long movieRefTime;
    long nextLocatorFP;
    long[] locatorTable;

    public IDNFile64Locator(TestEnvironment testEnvironment, TestScope testScope, long l, int n, int n2, IDNFile64Anchor iDNFile64Anchor, long l2) throws TestException {
        this.locatorFP = l;
        this.locNum = n;
        this.locatorTime = n2;
        this.anchorMsg = iDNFile64Anchor;
        this.movieRefTime = l2;
        testScope = new TestScope(testScope, "Locator%d FP(0x%s)", n, TestTools.toFPHexString(l));
        testScope.setAction("message header", new Object[0]);
        testEnvironment.seek(testScope, l);
        int n3 = testEnvironment.readUnsignedShort(testScope);
        int n4 = testEnvironment.readUnsignedShort(testScope);
        if (n4 != 14468) {
            throw new TestException(testScope, "Invalid contentID 0x%04X", n4);
        }
        testScope.setAction(null, new Object[0]);
        testEnvironment.checkReserved(testScope, l, 4);
        testScope.setAction("next locator FP", new Object[0]);
        this.nextLocatorFP = testEnvironment.readFP(testScope);
        testScope.setAction(null, new Object[0]);
        testEnvironment.checkOffset(testScope, l, 16L);
        testScope.setAction("locator table", new Object[0]);
        int n5 = n3 - 16;
        if (n5 == 0) {
            throw new TestException(testScope, "No table", new Object[0]);
        }
        if (n5 % 8 != 0) {
            throw new TestException(testScope, "Invalid table size %d", n5);
        }
        int n6 = n5 / 8;
        this.locatorTable = new long[n6];
        for (int i = 0; i < n6; ++i) {
            this.locatorTable[i] = testEnvironment.readFP(testScope);
        }
        testScope.setAction(null, new Object[0]);
        testEnvironment.checkOffset(testScope, l, n3);
    }

    public void checkLimits(TestEnvironment testEnvironment, TestScope testScope, long l, long l2) throws TestException {
        testScope = new TestScope(testScope, "Locator%d FP(0x%s)", this.locNum, TestTools.toFPHexString(this.locatorFP));
        String string = "";
        if (this.locatorTime == 0) {
            int n = 0;
            long l3 = this.locatorTable[0];
            TestScope testScope2 = new TestScope(testScope, "Entry[%d] =(0x%s)", n, TestTools.toFPHexString(l3));
            if (this.locatorTable[0] != l) {
                throw new TestException(testScope2, "First entry not pointing to first channel message at 0x%s", TestTools.toFPHexString(l));
            }
            string = ", first(OK)";
        }
        String string2 = "";
        if (this.nextLocatorFP == 0L) {
            int n = this.locatorTable.length - 1;
            long l4 = this.locatorTable[n];
            TestScope testScope3 = new TestScope(testScope, "Entry[%d] =(0x%s)", n, TestTools.toFPHexString(l4));
            long l5 = l2;
            if (this.locatorTable.length > 1) {
                l5 = this.locatorTable[this.locatorTable.length - 2];
            }
            if (l4 == l5) {
                throw new TestException(testScope3, "Last entry equals penultimate", new Object[0]);
            }
            testScope3.setAction("message", new Object[0]);
            testEnvironment.seek(testScope3, l4);
            int n2 = testEnvironment.readUnsignedShort(testScope3);
            int n3 = testEnvironment.readUnsignedShort(testScope3);
            if ((n3 & 0x8000) == 0) {
                throw new TestException(testScope3, "Last entry not a channel message", new Object[0]);
            }
            long l6 = l4 + (long)n2;
            if ((l6 = this.anchorMsg.seekNextChannelMessage(testEnvironment, testScope3, l6)) > 0L) {
                throw new TestException(testScope3, "Last entry's message followed by channel message at 0x%s", TestTools.toFPHexString(l6));
            }
            string2 = ", last(OK)";
        }
        if (testEnvironment.verboseMode) {
            System.out.printf("  Locator at 0x%s, %d entries%s%s\n", TestTools.toFPHexString(this.locatorFP), this.locatorTable.length, string, string2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkTable(TestEnvironment testEnvironment, TestScope testScope) throws TestException {
        testScope = new TestScope(testScope, "Locator%d FP(0x%s)", this.locNum, TestTools.toFPHexString(this.locatorFP));
        for (int i = 0; i < this.locatorTable.length; ++i) {
            long l;
            if (!testEnvironment.locatorCheckFlag && i != 0 && i != this.locatorTable.length * 1 / 4 && i != this.locatorTable.length * 2 / 4 && i != this.locatorTable.length * 3 / 4 && i != this.locatorTable.length - 1) continue;
            long l2 = this.locatorTable[i];
            TestScope testScope2 = new TestScope(testScope, "Entry[%d] =(0x%s)", i, TestTools.toFPHexString(l2));
            int n = this.locatorTime + i;
            long l3 = (long)n * 1000000L;
            long l4 = this.movieRefTime + l3 & 0xFFFFFFFFFFFFFFFFL;
            testScope2.setAction("message", new Object[0]);
            testEnvironment.seek(testScope2, l2);
            int n2 = testEnvironment.readUnsignedShort(testScope2);
            int n3 = testEnvironment.readUnsignedShort(testScope2);
            if ((n3 & 0x8000) == 0) {
                throw new TestException(testScope2, "Entry not pointing to a channel message", new Object[0]);
            }
            long l5 = (long)testEnvironment.readInt(testScope) & 0xFFFFFFFFFFFFFFFFL;
            testScope2.setAction("timestamp", new Object[0]);
            Object object = "";
            int n4 = (int)(l5 - l4 & 0xFFFFFFFFFFFFFFFFL);
            if (n4 > 0) {
                throw new TestException(testScope2, "Locator time before message time, diff=%d", n4);
            }
            if (n4 == 0) {
                object = this.locatorTime == 0 && i == 0 ? "OK(exact, first)" : (i == this.locatorTable.length - 1 && this.nextLocatorFP == 0L ? "OK(exact, last)" : "OK(exact)");
            } else {
                l = l2 + (long)n2;
                if ((l = this.anchorMsg.seekNextChannelMessage(testEnvironment, testScope2, l)) <= 0L) {
                    if (i != this.locatorTable.length - 1 || this.nextLocatorFP != 0L) throw new TestException(testScope2, "Entry has no succeeding channel message", new Object[0]);
                    object = "OK(" + n4 + ", last)";
                } else {
                    TestScope testScope3 = new TestScope(testScope2, "Message[0x%s]", TestTools.toFPHexString(l));
                    n2 = testEnvironment.readUnsignedShort(testScope3);
                    n3 = testEnvironment.readUnsignedShort(testScope3);
                    long l6 = (long)testEnvironment.readInt(testScope) & 0xFFFFFFFFFFFFFFFFL;
                    int n5 = (int)(l6 - l4 & 0xFFFFFFFFFFFFFFFFL);
                    if (n5 < 0) {
                        throw new TestException(testScope3, "Locator time past next message time, diff=%d", n5);
                    }
                    if (n5 == 0) {
                        throw new TestException(testScope3, "Locator time equals next message time", new Object[0]);
                    }
                    object = "OK(" + n4 + "/" + n5 + ")";
                }
            }
            if (testEnvironment.verboseMode) {
                System.out.printf("    %d (0x%s): %d/0x%08X, %s\n", i, TestTools.toFPHexString(l2), n, (int)l4, object);
            }
            testScope.setAction("duration", new Object[0]);
            if (i != this.locatorTable.length - 1 || this.nextLocatorFP != 0L) continue;
            l = l3 + (long)n4;
            long l7 = l / 1000L;
            if (l7 == 0L || l % 1000L != 0L) {
                ++l7;
            }
            long l8 = l7 + 1000L;
            if (this.anchorMsg.durationMS < l7 || this.anchorMsg.durationMS >= l8) {
                throw new TestException(testScope, "Anchor stream duration check failed, minDuration=%d, maxDuration=%d", testScope, l7, l8);
            }
            if (!testEnvironment.verboseMode) continue;
            System.out.printf("    Stream duration check OK: %d <= %d < %d\n", l7, this.anchorMsg.durationMS, l8);
        }
    }
}

