/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.idnFileCheck;

import dexlogic.idnFileCheck.Channel;
import dexlogic.idnFileCheck.File64Track;
import dexlogic.idnFileCheck.IDNChannelMessage;
import dexlogic.idnFileCheck.IDNFile64Locator;
import dexlogic.idnFileCheck.TestEnvironment;
import dexlogic.idnFileCheck.TestException;
import dexlogic.idnFileCheck.TestScope;
import dexlogic.idnFileCheck.TestTools;
import java.util.ArrayList;

public class IDNFile64Anchor {
    long anchorFP;
    int anchorNum;
    String streamName;
    long nextAnchorFP;
    long propertiesFP;
    long editorFP;
    long durationMS;
    long movieFirstFP;
    long movieLastFP;
    long movieLength;
    long movieLocatorFP;
    ArrayList<File64Track> tracks = new ArrayList();

    void checkBeacon(TestEnvironment testEnvironment, TestScope testScope, long l) throws TestException {
        testScope = new TestScope("Beacon FP(0x%s)", TestTools.toFPHexString(l));
        testScope.setAction("message header", new Object[0]);
        testEnvironment.seek(testScope, l);
        int n = testEnvironment.readUnsignedShort(testScope);
        int n2 = testEnvironment.readUnsignedShort(testScope);
        testScope.setAction("CID copy", new Object[0]);
        int n3 = testEnvironment.readUnsignedShort(testScope);
        if (n2 != n3) {
            throw new TestException(testScope, "Content ID copy check failed", new Object[0]);
        }
        testScope.setAction("CRC", new Object[0]);
        int n4 = testEnvironment.readUnsignedShort(testScope);
        testScope.setAction("payload data", new Object[0]);
        byte[] byArray = new byte[n - 8];
        testEnvironment.readFully(testScope, byArray);
        int n5 = TestTools.crc16Chunk(0, byArray, 0, byArray.length);
        if (n4 != n5) {
            throw new TestException(testScope, "CRC check failed, beaconCRC=0x%04X, calcCRC=0x%04X", n4, n5);
        }
        if (testEnvironment.verboseMode) {
            String string = "Beacon";
            if (n2 == 14357) {
                string = "Start beacon";
            }
            if (n2 == 14359) {
                string = "End beacon";
            }
            System.out.printf("  %s at 0x%s, OK\n", string, TestTools.toFPHexString(l));
        }
    }

    long seekNextChannelMessage(TestEnvironment testEnvironment, TestScope testScope, long l) throws TestException {
        testScope = new TestScope(testScope);
        while (true) {
            testScope.setNode("Message FP(0x%s)", TestTools.toFPHexString(l));
            if (l > this.movieLastFP) {
                return 0L;
            }
            testScope.setAction("message header", new Object[0]);
            testEnvironment.seek(testScope, l);
            int n = testEnvironment.readUnsignedShort(testScope);
            int n2 = testEnvironment.readUnsignedShort(testScope);
            if ((n2 & 0x8000) != 0) break;
            l += (long)n;
        }
        testEnvironment.seek(testScope, l);
        return l;
    }

    public IDNFile64Anchor(TestEnvironment testEnvironment, long l, int n) throws TestException {
        int n2;
        this.anchorFP = l;
        this.anchorNum = n;
        TestScope testScope = new TestScope("Anchor%d FP(0x%s)", n, TestTools.toFPHexString(l));
        testScope.setAction("message header", new Object[0]);
        testEnvironment.seek(testScope, l);
        int n3 = testEnvironment.readUnsignedShort(testScope);
        int n4 = testEnvironment.readUnsignedShort(testScope);
        if (n4 != 14464) {
            throw new TestException(testScope, "Invalid contentID 0x%04X", n4);
        }
        testScope.setAction("stream name", new Object[0]);
        this.streamName = testEnvironment.readStringField(testScope, 20);
        testScope.setAction("next anchor FP", new Object[0]);
        this.nextAnchorFP = testEnvironment.readFP(testScope);
        testScope.setAction("properties FP", new Object[0]);
        this.propertiesFP = testEnvironment.readFP(testScope);
        testScope.setAction("editor FP", new Object[0]);
        this.editorFP = testEnvironment.readFP(testScope);
        testScope.setAction("duration", new Object[0]);
        this.durationMS = (long)testEnvironment.readInt(testScope) & 0xFFFFFFFFFFFFFFFFL;
        testScope.setAction(null, new Object[0]);
        testEnvironment.checkReserved(testScope, l, 4);
        testEnvironment.checkReserved(testScope, l, 8);
        testScope.setAction(null, new Object[0]);
        testEnvironment.checkReserved(testScope, l, 8);
        testEnvironment.checkReserved(testScope, l, 8);
        testEnvironment.checkReserved(testScope, l, 8);
        testEnvironment.checkReserved(testScope, l, 8);
        testScope.setAction("movie first FP", new Object[0]);
        this.movieFirstFP = testEnvironment.readFP(testScope);
        testScope.setAction("movie last FP", new Object[0]);
        this.movieLastFP = testEnvironment.readFP(testScope);
        testScope.setAction("movie length", new Object[0]);
        this.movieLength = testEnvironment.readFP(testScope);
        testScope.setAction("movie locator FP", new Object[0]);
        this.movieLocatorFP = testEnvironment.readFP(testScope);
        if (testEnvironment.verboseMode) {
            System.out.printf("Anchor 0x%s: %s, duration=%d.%03d sec\n", TestTools.toFPHexString(l), this.streamName, this.durationMS / 1000L, this.durationMS % 1000L);
        }
        testScope.setAction("movie view", new Object[0]);
        if (this.movieFirstFP == 0L) {
            if (this.movieLastFP != 0L) {
                throw new TestException(testScope, "No movie view but movieLastFP=0x%s", TestTools.toFPHexString(this.movieLastFP));
            }
            if (this.movieLength != 0L) {
                throw new TestException(testScope, "No movie view but movieLength=0x%s", TestTools.toFPHexString(this.movieLength));
            }
            if (this.movieLocatorFP != 0L) {
                throw new TestException(testScope, "No movie view but movieLocatorFP=0x%s", TestTools.toFPHexString(this.movieLocatorFP));
            }
        }
        if (this.durationMS == 0L && this.movieFirstFP != 0L || this.durationMS != 0L && this.movieFirstFP == 0L) {
            throw new TestException(testScope, "Invalid stream duration, movieFirstFP=0x%s, StreamDurationMS=%d", TestTools.toFPHexString(this.movieFirstFP), this.durationMS);
        }
        testScope.setAction(null, new Object[0]);
        testEnvironment.checkOffset(testScope, l, 128L);
        testScope.setAction("track table", new Object[0]);
        int n5 = 0;
        for (n2 = 128; n2 < n3; n2 += 64) {
            if (n2 + 64 > n3) {
                throw new TestException(testScope, "Invalid track table length: %d octets", n3 - 128);
            }
            this.tracks.add(new File64Track(testEnvironment, testScope, l + (long)n2, n5));
            ++n5;
        }
        byte[] byArray = new byte[256];
        n2 = this.tracks.size();
        for (int i = 0; i < n2; ++i) {
            File64Track file64Track = this.tracks.get(i);
            if (file64Track.serviceID == 0) continue;
            if (file64Track.serviceID > 255) {
                throw new TestException(testScope, "Invalid track entry, index=%d, serviceID=%d", i, file64Track.serviceID);
            }
            if (byArray[file64Track.serviceID] != 0) {
                throw new TestException(testScope, "Duplicate serviceID, index=%d, serviceID=%d", i, file64Track.serviceID);
            }
            byArray[file64Track.serviceID] = 1;
        }
        testScope.setAction(null, new Object[0]);
        testEnvironment.checkOffset(testScope, l, n3);
    }

    public void checkMovie(TestEnvironment testEnvironment) throws TestException {
        boolean bl;
        boolean bl2;
        TestScope testScope = new TestScope("Anchor%d FP(0x%s)", this.anchorNum, TestTools.toFPHexString(this.anchorFP));
        testScope.setAction("first movie message", new Object[0]);
        testEnvironment.seek(testScope, this.movieFirstFP);
        int n = testEnvironment.readUnsignedShort(testScope);
        int n2 = testEnvironment.readUnsignedShort(testScope);
        boolean bl3 = bl2 = n2 == 14357;
        if (bl2) {
            this.checkBeacon(testEnvironment, testScope, this.movieFirstFP);
        }
        testScope.setAction("last movie message", new Object[0]);
        testEnvironment.seek(testScope, this.movieLastFP);
        n = testEnvironment.readUnsignedShort(testScope);
        n2 = testEnvironment.readUnsignedShort(testScope);
        boolean bl4 = bl = n2 == 14359;
        if (bl) {
            this.checkBeacon(testEnvironment, testScope, this.movieLastFP);
        }
        testScope.setAction("movie view", new Object[0]);
        if (bl2 != bl) {
            throw new TestException(testScope, "Recovery beacon mismatch, start=%b, end=%b", bl2, bl);
        }
        if (testEnvironment.verboseMode) {
            System.out.printf("  Movie, first 0x%s, last 0x%s, length %d\n", TestTools.toFPHexString(this.movieFirstFP), TestTools.toFPHexString(this.movieLastFP), this.movieLength);
        }
        testScope.setAction("movie length", new Object[0]);
        long l = this.movieLastFP - this.movieFirstFP + (long)n;
        if (l != this.movieLength) {
            throw new TestException(testScope, "Movie length mismatch, expected=%d, calculated=%d", this.movieLength, l);
        }
        testScope.setAction("first channel message", new Object[0]);
        long l2 = this.seekNextChannelMessage(testEnvironment, testScope, this.movieFirstFP);
        if (l2 <= 0L) {
            throw new TestException(testScope, "Movie has no channel messages", new Object[0]);
        }
        n = testEnvironment.readUnsignedShort(testScope);
        n2 = testEnvironment.readUnsignedShort(testScope);
        long l3 = (long)testEnvironment.readInt(testScope) & 0xFFFFFFFFFFFFFFFFL;
        testScope.setAction(null, new Object[0]);
        int n3 = 0;
        long l4 = 0L;
        long l5 = this.movieLocatorFP;
        int n4 = 1;
        while (l5 != 0L) {
            IDNFile64Locator iDNFile64Locator = new IDNFile64Locator(testEnvironment, testScope, l5, n4, n3, this, l3);
            iDNFile64Locator.checkLimits(testEnvironment, testScope, l2, l4);
            iDNFile64Locator.checkTable(testEnvironment, testScope);
            l4 = iDNFile64Locator.locatorTable[iDNFile64Locator.locatorTable.length - 1];
            n3 += iDNFile64Locator.locatorTable.length;
            l5 = iDNFile64Locator.nextLocatorFP;
            ++n4;
        }
        testScope.setAction(null, new Object[0]);
        long l6 = -1L;
        Channel[] channelArray = new Channel[64];
        for (long i = this.movieFirstFP; i <= this.movieLastFP; i += (long)n) {
            testEnvironment.seek(testScope, i);
            n = testEnvironment.readUnsignedShort(testScope);
            n2 = testEnvironment.readUnsignedShort(testScope);
            if ((n2 & 0x8000) == 0) continue;
            IDNChannelMessage iDNChannelMessage = new IDNChannelMessage(testEnvironment, testScope, i);
            iDNChannelMessage.checkMessage(testEnvironment, testScope, l6, channelArray);
            l6 = (long)iDNChannelMessage.timestamp & 0xFFFFFFFFFFFFFFFFL;
        }
        for (int i = 0; i < 64; ++i) {
            if (channelArray[i] == null) continue;
            System.out.printf("  Channel %d not closed\n", i);
        }
    }
}

