/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.idnFileCheck;

import dexlogic.idnFileCheck.TestEnvironment;
import dexlogic.idnFileCheck.TestException;
import dexlogic.idnFileCheck.TestScope;
import dexlogic.idnFileCheck.TestTools;

public class File64Track {
    long trackFP;
    int serviceID;
    int serviceType;
    int flags;
    String trackName;
    long propertiesFP;
    long editorFP;
    long indexFP;

    public File64Track(TestEnvironment testEnvironment, TestScope testScope, long l, int n) throws TestException {
        this.trackFP = l;
        testScope = new TestScope(testScope, "Track[%d] FP(0x%s)", n, TestTools.toFPHexString(l));
        testScope.setAction("service ID", new Object[0]);
        testEnvironment.seek(testScope, l);
        this.serviceID = testEnvironment.readUnsignedByte(testScope) & 0xFF;
        testScope.setAction("service type", new Object[0]);
        this.serviceType = testEnvironment.readUnsignedByte(testScope) & 0xFF;
        testScope.setAction("flags", new Object[0]);
        this.flags = testEnvironment.readUnsignedByte(testScope) & 0xFF;
        testScope.setAction(null, new Object[0]);
        testEnvironment.checkReserved(testScope, l, 1);
        testScope.setAction("track name", new Object[0]);
        String string = testEnvironment.readStringField(testScope, 20);
        testScope.setAction("properties FP", new Object[0]);
        this.propertiesFP = testEnvironment.readFP(testScope);
        testScope.setAction("editor FP", new Object[0]);
        this.editorFP = testEnvironment.readFP(testScope);
        testScope.setAction("index FP", new Object[0]);
        this.indexFP = testEnvironment.readFP(testScope);
        testScope.setAction(null, new Object[0]);
        testEnvironment.checkReserved(testScope, l, 8);
        testEnvironment.checkReserved(testScope, l, 8);
        testScope.setAction(null, new Object[0]);
        testEnvironment.checkOffset(testScope, l, 64L);
        if (testEnvironment.verboseMode) {
            String string2 = this.serviceID == 0 ? ", void" : "";
            System.out.printf("  ServiceID %3d, type=0x%02X, flags=0x%02X, name='%s'%s\n", this.serviceID, this.serviceType, this.flags, string, string2);
        }
    }
}

